/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.event;

import com.google.common.reflect.AbstractInvocationHandler;
import dev.architectury.annotations.ForgeEvent;
import dev.architectury.annotations.ForgeEventCancellable;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.Event;
import dev.architectury.event.EventActor;
import dev.architectury.event.EventResult;
import dev.architectury.event.forge.EventFactoryImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class EventFactory {
    private EventFactory() {
    }

    public static <T> Event<T> of(Function<List<T>, T> function) {
        return new EventImpl<T>(function);
    }

    @SafeVarargs
    public static <T> Event<T> createLoop(T ... typeGetter) {
        if (typeGetter.length != 0) {
            throw new IllegalStateException("array must be empty!");
        }
        return EventFactory.createLoop(typeGetter.getClass().getComponentType());
    }

    private static <T, R> R invokeMethod(T listener, Method method, Object[] args) throws Throwable {
        return (R)MethodHandles.lookup().unreflect(method).bindTo(listener).invokeWithArguments(args);
    }

    public static <T> Event<T> createLoop(Class<T> clazz) {
        return EventFactory.of(listeners -> Proxy.newProxyInstance(EventFactory.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AbstractInvocationHandler((List)listeners){
            final /* synthetic */ List val$listeners;
            {
                this.val$listeners = list;
            }

            protected Object handleInvocation(@NotNull Object proxy, @NotNull Method method, Object @NotNull [] args) throws Throwable {
                for (Object listener : this.val$listeners) {
                    EventFactory.invokeMethod(listener, method, args);
                }
                return null;
            }
        }));
    }

    @SafeVarargs
    public static <T> Event<T> createEventResult(T ... typeGetter) {
        if (typeGetter.length != 0) {
            throw new IllegalStateException("array must be empty!");
        }
        return EventFactory.createEventResult(typeGetter.getClass().getComponentType());
    }

    public static <T> Event<T> createEventResult(Class<T> clazz) {
        return EventFactory.of(listeners -> Proxy.newProxyInstance(EventFactory.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AbstractInvocationHandler((List)listeners){
            final /* synthetic */ List val$listeners;
            {
                this.val$listeners = list;
            }

            protected Object handleInvocation(@NotNull Object proxy, @NotNull Method method, Object @NotNull [] args) throws Throwable {
                for (Object listener : this.val$listeners) {
                    EventResult result = (EventResult)Objects.requireNonNull(EventFactory.invokeMethod(listener, method, args));
                    if (!result.interruptsFurtherEvaluation()) continue;
                    return result;
                }
                return EventResult.pass();
            }
        }));
    }

    @SafeVarargs
    public static <T> Event<T> createCompoundEventResult(T ... typeGetter) {
        if (typeGetter.length != 0) {
            throw new IllegalStateException("array must be empty!");
        }
        return EventFactory.createCompoundEventResult(typeGetter.getClass().getComponentType());
    }

    public static <T> Event<T> createCompoundEventResult(Class<T> clazz) {
        return EventFactory.of(listeners -> Proxy.newProxyInstance(EventFactory.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AbstractInvocationHandler((List)listeners){
            final /* synthetic */ List val$listeners;
            {
                this.val$listeners = list;
            }

            protected Object handleInvocation(@NotNull Object proxy, @NotNull Method method, Object @NotNull [] args) throws Throwable {
                for (Object listener : this.val$listeners) {
                    CompoundEventResult result = (CompoundEventResult)Objects.requireNonNull(EventFactory.invokeMethod(listener, method, args));
                    if (!result.interruptsFurtherEvaluation()) continue;
                    return result;
                }
                return CompoundEventResult.pass();
            }
        }));
    }

    @SafeVarargs
    public static <T> Event<Consumer<T>> createConsumerLoop(T ... typeGetter) {
        if (typeGetter.length != 0) {
            throw new IllegalStateException("array must be empty!");
        }
        return EventFactory.createConsumerLoop(typeGetter.getClass().getComponentType());
    }

    public static <T> Event<Consumer<T>> createConsumerLoop(Class<T> clazz) {
        Event<Consumer<T>> event = EventFactory.of(listeners -> (Consumer)Proxy.newProxyInstance(EventFactory.class.getClassLoader(), new Class[]{Consumer.class}, (InvocationHandler)new AbstractInvocationHandler((List)listeners){
            final /* synthetic */ List val$listeners;
            {
                this.val$listeners = list;
            }

            protected Object handleInvocation(@NotNull Object proxy, @NotNull Method method, Object @NotNull [] args) throws Throwable {
                for (Consumer listener : this.val$listeners) {
                    EventFactory.invokeMethod(listener, method, args);
                }
                return null;
            }
        }));
        Class<T> superClass = clazz;
        do {
            if (!superClass.isAnnotationPresent(ForgeEvent.class)) continue;
            return EventFactory.attachToForge(event);
        } while ((superClass = superClass.getSuperclass()) != null);
        return event;
    }

    @SafeVarargs
    public static <T> Event<EventActor<T>> createEventActorLoop(T ... typeGetter) {
        if (typeGetter.length != 0) {
            throw new IllegalStateException("array must be empty!");
        }
        return EventFactory.createEventActorLoop(typeGetter.getClass().getComponentType());
    }

    public static <T> Event<EventActor<T>> createEventActorLoop(Class<T> clazz) {
        Event<EventActor<T>> event = EventFactory.of(listeners -> (EventActor)Proxy.newProxyInstance(EventFactory.class.getClassLoader(), new Class[]{EventActor.class}, (InvocationHandler)new AbstractInvocationHandler((List)listeners){
            final /* synthetic */ List val$listeners;
            {
                this.val$listeners = list;
            }

            protected Object handleInvocation(@NotNull Object proxy, @NotNull Method method, Object @NotNull [] args) throws Throwable {
                for (EventActor listener : this.val$listeners) {
                    EventResult result = (EventResult)EventFactory.invokeMethod(listener, method, args);
                    if (!result.interruptsFurtherEvaluation()) continue;
                    return result;
                }
                return EventResult.pass();
            }
        }));
        Class<T> superClass = clazz;
        do {
            if (!superClass.isAnnotationPresent(ForgeEventCancellable.class)) continue;
            return EventFactory.attachToForgeEventActorCancellable(event);
        } while ((superClass = superClass.getSuperclass()) != null);
        superClass = clazz;
        do {
            if (!superClass.isAnnotationPresent(ForgeEvent.class)) continue;
            return EventFactory.attachToForgeEventActor(event);
        } while ((superClass = superClass.getSuperclass()) != null);
        return event;
    }

    @ExpectPlatform
    @ApiStatus.Internal
    @ExpectPlatform.Transformed
    public static <T> Event<Consumer<T>> attachToForge(Event<Consumer<T>> event) {
        return EventFactoryImpl.attachToForge(event);
    }

    @ExpectPlatform
    @ApiStatus.Internal
    @ExpectPlatform.Transformed
    public static <T> Event<EventActor<T>> attachToForgeEventActor(Event<EventActor<T>> event) {
        return EventFactoryImpl.attachToForgeEventActor(event);
    }

    @ExpectPlatform
    @ApiStatus.Internal
    @ExpectPlatform.Transformed
    public static <T> Event<EventActor<T>> attachToForgeEventActorCancellable(Event<EventActor<T>> event) {
        return EventFactoryImpl.attachToForgeEventActorCancellable(event);
    }

    private static class EventImpl<T>
    implements Event<T> {
        private final Function<List<T>, T> function;
        private T invoker = null;
        private ArrayList<T> listeners;

        public EventImpl(Function<List<T>, T> function) {
            this.function = function;
            this.listeners = new ArrayList();
        }

        @Override
        public T invoker() {
            if (this.invoker == null) {
                this.update();
            }
            return this.invoker;
        }

        @Override
        public void register(T listener) {
            this.listeners.add(listener);
            this.invoker = null;
        }

        @Override
        public void unregister(T listener) {
            this.listeners.remove(listener);
            this.listeners.trimToSize();
            this.invoker = null;
        }

        @Override
        public boolean isRegistered(T listener) {
            return this.listeners.contains(listener);
        }

        @Override
        public void clearListeners() {
            this.listeners.clear();
            this.listeners.trimToSize();
            this.invoker = null;
        }

        public void update() {
            this.invoker = this.listeners.size() == 1 ? this.listeners.get(0) : this.function.apply(this.listeners);
        }
    }
}

