/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.handler;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class BabyConversionHandler {
    private static final Map<EntityType<? extends Mob>, EntityType<? extends Mob>> BABY_MOB_CONVERSIONS = Maps.newHashMap();

    public static void registerConversion(EntityType<? extends Mob> targetMob, EntityType<? extends Mob> convertsTo) {
        BABY_MOB_CONVERSIONS.put(targetMob, convertsTo);
    }

    public void onLivingPackSize(LivingPackSizeEvent evt) {
        EntityType<? extends Mob> babyType;
        ServerLevel level;
        Level level2 = evt.getEntity().f_19853_;
        if (level2 instanceof ServerLevel && Zombie.m_34302_((Random)(level = (ServerLevel)level2).m_5822_()) && (babyType = BABY_MOB_CONVERSIONS.get(evt.getEntity().m_6095_())) != null) {
            BabyConversionHandler.makeBabyMob(level, babyType, evt.getEntity(), MobSpawnType.NATURAL).ifPresent(mobentity -> evt.getEntity().m_146870_());
        }
    }

    public void onSpecialSpawn(LivingSpawnEvent.SpecialSpawn evt) {
        EntityType<? extends Mob> babyType;
        ServerLevel level;
        LevelAccessor levelAccessor;
        MobSpawnType spawnReason = evt.getSpawnReason();
        if (spawnReason != MobSpawnType.NATURAL && spawnReason != MobSpawnType.SPAWNER && spawnReason != MobSpawnType.COMMAND && (levelAccessor = evt.getWorld()) instanceof ServerLevel && Zombie.m_34302_((Random)(level = (ServerLevel)levelAccessor).m_5822_()) && (babyType = BABY_MOB_CONVERSIONS.get(evt.getEntity().m_6095_())) != null) {
            BabyConversionHandler.makeBabyMob(level, babyType, evt.getEntity(), spawnReason).ifPresent(mobentity -> evt.setCanceled(true));
        }
    }

    public void onEntityInteract(PlayerInteractEvent.EntityInteract evt) {
        ItemStack itemstack;
        EntityType eggType;
        EntityType<? extends Mob> babyType;
        Entity target = evt.getTarget();
        if (target.m_6084_() && evt.getItemStack().m_41720_() instanceof SpawnEggItem && (babyType = BABY_MOB_CONVERSIONS.get(eggType = ((SpawnEggItem)(itemstack = evt.getItemStack()).m_41720_()).m_43228_(itemstack.m_41783_()))) != null && (target.m_6095_() == babyType || target.m_6095_() == eggType)) {
            evt.setCanceled(true);
            Level level = evt.getWorld();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                Optional<Mob> mob = BabyConversionHandler.makeBabyMob(level2, babyType, target, MobSpawnType.SPAWN_EGG);
                if (mob.isPresent()) {
                    this.finalizeSpawnEggMob(mob.get(), itemstack, evt.getPlayer());
                    evt.setCancellationResult(InteractionResult.SUCCESS);
                    return;
                }
                evt.setCancellationResult(InteractionResult.PASS);
            } else {
                evt.setCancellationResult(InteractionResult.CONSUME);
            }
        }
    }

    private void finalizeSpawnEggMob(Mob mobentity, ItemStack itemstack, Player player) {
        mobentity.m_8032_();
        if (itemstack.m_41788_()) {
            mobentity.m_6593_(itemstack.m_41786_());
        }
        if (!player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)itemstack.m_41720_()));
    }

    private static Optional<Mob> makeBabyMob(ServerLevel level, EntityType<? extends Mob> entityType, Entity parent, MobSpawnType spawnReason) {
        Mob mobentity;
        if (parent instanceof AgeableMob) {
            AgeableMob ageableMob = (AgeableMob)parent;
            mobentity = ageableMob.m_142606_(level, ageableMob);
        } else {
            mobentity = (Mob)entityType.m_20615_((Level)level);
        }
        if (mobentity == null) {
            return Optional.empty();
        }
        if (!mobentity.m_6162_()) {
            throw new RuntimeException("baby mob must be a baby by default");
        }
        mobentity.m_7678_(parent.m_20185_(), parent.m_20186_(), parent.m_20189_(), Mth.m_14177_((float)(level.f_46441_.nextFloat() * 360.0f)), 0.0f);
        mobentity.f_20885_ = mobentity.m_146908_();
        mobentity.f_20883_ = mobentity.m_146908_();
        mobentity.m_6518_((ServerLevelAccessor)level, level.m_6436_(mobentity.m_142538_()), spawnReason, null, null);
        level.m_47205_((Entity)mobentity);
        return Optional.of(mobentity);
    }
}

