/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.event;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import noobanidus.mods.lootr.api.LootrAPI;

@Mod.EventBusSubscriber(modid="lootr")
public class HandleMigrate {
    private static void append(StringBuilder builder, int intVal) {
        HandleMigrate.append(builder, intVal, true);
    }

    private static void append(StringBuilder builder, int intVal, boolean sep) {
        if (intVal < 10) {
            builder.append('0').append(intVal);
        } else {
            builder.append(intVal);
        }
        if (sep) {
            builder.append('-');
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartedEvent event) {
        List toMigrate;
        Path data = event.getServer().m_129843_(new LevelResource("data"));
        Path dataLootr = data.resolve("lootr");
        try {
            toMigrate = Files.walk(event.getServer().m_129843_(new LevelResource("data")), 1, new FileVisitOption[0]).collect(Collectors.toList());
        }
        catch (IOException e) {
            LootrAPI.LOG.error("Unable to begin migration of existing data!", (Throwable)e);
            return;
        }
        toMigrate.removeIf(path -> !path.getFileName().toString().startsWith("Lootr-"));
        if (!toMigrate.isEmpty()) {
            ZipOutputStream backupZip;
            LootrAPI.LOG.info("Backing up {} files...", (Object)toMigrate.size());
            Calendar time = Calendar.getInstance();
            StringBuilder filenameBuilder = new StringBuilder();
            filenameBuilder.append("LootrMigrationBackup-");
            HandleMigrate.append(filenameBuilder, time.get(1));
            HandleMigrate.append(filenameBuilder, time.get(2) + 1);
            HandleMigrate.append(filenameBuilder, time.get(5));
            HandleMigrate.append(filenameBuilder, time.get(11));
            HandleMigrate.append(filenameBuilder, time.get(12));
            HandleMigrate.append(filenameBuilder, time.get(13), false);
            String string = filenameBuilder.toString();
            Path backupName = data.resolve(string + ".zip");
            File backup = backupName.toFile();
            int inc = 0;
            while (backup.exists()) {
                backupName = data.resolve(string + "-" + inc + ".zip");
                backup = backupName.toFile();
                if (inc++ < 99) continue;
                throw new IllegalStateException("Unable to create backup for Lootr data files. Reached '" + string + "-" + inc + ".zip' and all files exist!");
            }
            try {
                backup.getParentFile().mkdirs();
                if (!backup.createNewFile()) {
                    throw new IllegalStateException("Unable to create backup for Lootr data files! Couldn't create " + backup);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create backup for Lootr data files!", e);
            }
            try {
                backupZip = new ZipOutputStream(new FileOutputStream(backup));
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Unable to create backup for Lootr data files!", e);
            }
            backupZip.setLevel(0);
            boolean failure = false;
            byte[] readBuffer = new byte[4096];
            for (Path path2 : toMigrate) {
                ZipEntry entry = new ZipEntry(path2.getFileName().toString());
                try {
                    int len;
                    backupZip.putNextEntry(entry);
                    FileInputStream inputStream = new FileInputStream(path2.toFile());
                    while ((len = inputStream.read(readBuffer)) > 0) {
                        backupZip.write(readBuffer, 0, len);
                    }
                    backupZip.closeEntry();
                    inputStream.close();
                }
                catch (IOException e) {
                    failure = true;
                    LootrAPI.LOG.error("Unable to fully back-up Lootr data, failure while reading: {}", (Object)path2, (Object)e);
                }
            }
            try {
                backupZip.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close current back-up file: " + backup, e);
            }
            if (failure) {
                throw new IllegalStateException("Unable to fully back-up Lootr data. Please check log file for details as to which file failed to back-up.");
            }
            LootrAPI.LOG.info("Completed backup! {} files were backed up to {}", (Object)toMigrate.size(), (Object)backup);
        }
        HashMap<Path, Path> migrations = new HashMap<Path, Path>();
        for (Path path2 : toMigrate) {
            String uuid;
            String fileName = path2.getFileName().toString();
            if (fileName.startsWith("Lootr-AdvancementData") || fileName.startsWith("Lootr-ScoreData") || fileName.startsWith("Lootr-DecayData") || fileName.startsWith("Lootr-RefreshData")) {
                migrations.put(path2, dataLootr.resolve(path2.getFileName()));
                continue;
            }
            if (fileName.startsWith("Lootr-chests") || fileName.startsWith("Lootr-custom")) {
                uuid = fileName.split("-", 4)[3];
            } else if (fileName.startsWith("Lootr-entity")) {
                uuid = fileName.split("-", 3)[2];
            } else {
                LootrAPI.LOG.error("Invalid file name found while traversing data. Could not migrate: '" + path2 + "'");
                continue;
            }
            String containerId = uuid.substring(0, 2);
            try {
                Files.createDirectories(dataLootr.resolve(uuid.substring(0, 1)).resolve(containerId), new FileAttribute[0]);
            }
            catch (IOException e) {
                LootrAPI.LOG.error("Unable to create 'lootr/" + containerId + "' subdirectory. Could not migrate: '" + path2 + "'", (Throwable)e);
                continue;
            }
            migrations.put(path2, dataLootr.resolve(uuid.substring(0, 1)).resolve(containerId).resolve(uuid));
        }
        if (!migrations.isEmpty()) {
            LootrAPI.LOG.info("Migrating Lootr data files to subdirectory...");
            for (Map.Entry entry : migrations.entrySet()) {
                try {
                    Files.move((Path)entry.getKey(), (Path)entry.getValue(), new CopyOption[0]);
                }
                catch (IOException e) {
                    LootrAPI.LOG.error("Unable to migrate from '" + entry.getKey() + "' to '" + entry.getValue() + "'", (Throwable)e);
                }
            }
            LootrAPI.LOG.info("Migrated " + migrations.size() + " Lootr data files to subdirectory!");
        }
    }
}

