/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.create.behaviors;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.integration.create.behaviors.MovementUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BambooSpikesBehavior
extends MovementBehaviour {
    public boolean isSameDir(MovementContext context) {
        return VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)((Direction)context.state.m_61143_((Property)BambooSpikesBlock.FACING)));
    }

    public boolean renderAsNormalTileEntity() {
        return true;
    }

    public void tick(MovementContext context) {
        this.damageEntities(context);
    }

    public void damageEntities(MovementContext context) {
        Level world = context.world;
        Vec3 pos = context.position;
        DamageSource damageSource = this.getDamageSource();
        block0: for (Entity entity2 : world.m_45976_(Entity.class, new AABB(pos.m_82520_(-0.5, -0.5, -0.5), pos.m_82520_(0.5, 0.5, 0.5)))) {
            Object player;
            if (entity2 instanceof ItemEntity || entity2 instanceof AbstractContraptionEntity || entity2 instanceof Player && (player = (Player)entity2).m_7500_()) continue;
            if (entity2 instanceof AbstractMinecart) {
                player = entity2.m_146897_().iterator();
                while (player.hasNext()) {
                    Entity passenger = (Entity)player.next();
                    if (!(passenger instanceof AbstractContraptionEntity) || ((AbstractContraptionEntity)passenger).getContraption() != context.contraption) continue;
                    continue block0;
                }
            }
            if (entity2.m_6084_() && entity2 instanceof LivingEntity && !world.f_46443_) {
                double pow = 5.0 * Math.pow(context.relativeMotion.m_82553_(), 0.4) + 1.0;
                float damage = !this.isSameDir(context) ? 1.0f : (float)Mth.m_14008_((double)pow, (double)2.0, (double)6.0);
                entity2.m_6469_(damageSource, damage);
                this.doTileStuff(context, world, (LivingEntity)entity2);
            }
            if (world.f_46443_ != entity2 instanceof Player) continue;
            Vec3 motionBoost = context.motion.m_82520_(0.0, context.motion.m_82553_() / 4.0, 0.0);
            int maxBoost = 4;
            if (motionBoost.m_82553_() > (double)maxBoost) {
                motionBoost = motionBoost.m_82546_(motionBoost.m_82541_().m_82490_(motionBoost.m_82553_() - (double)maxBoost));
            }
            entity2.m_20256_(entity2.m_20184_().m_82549_(motionBoost));
            entity2.f_19864_ = true;
        }
    }

    private void doTileStuff(MovementContext context, @Nonnull Level world, LivingEntity le) {
        CompoundTag com = context.tileData;
        int charges = com.m_128451_("Charges");
        long lastTicked = com.m_128454_("LastTicked");
        Potion potion = PotionUtils.m_43577_((CompoundTag)com);
        if (potion != Potions.f_43598_ && charges > 0 && !this.isOnCooldown(world, lastTicked)) {
            boolean used = false;
            for (MobEffectInstance effect : potion.m_43488_()) {
                if (!le.m_7301_(effect) || le.m_21023_(effect.m_19544_())) continue;
                if (effect.m_19544_().m_8093_()) {
                    float health = 0.5f;
                    effect.m_19544_().m_19461_(null, null, le, effect.m_19564_(), (double)health);
                } else {
                    le.m_7292_(new MobEffectInstance(effect.m_19544_(), (int)((float)effect.m_19557_() * 0.1f), effect.m_19564_()));
                }
                used = true;
            }
            if (used) {
                lastTicked = world.m_46467_();
                if (--charges <= 0) {
                    charges = 0;
                    potion = Potions.f_43598_;
                    MovementUtils.changeState(context, (BlockState)context.state.m_61124_((Property)BambooSpikesBlock.TIPPED, (Comparable)Boolean.valueOf(false)));
                }
                com.m_128473_("Charges");
                com.m_128473_("LastTicked");
                com.m_128473_("Potion");
                com.m_128405_("Charges", charges);
                com.m_128356_("LastTicked", lastTicked);
                com.m_128359_("Potion", Registry.f_122828_.m_7981_((Object)potion).toString());
                context.tileData = com;
            }
        }
    }

    public boolean isOnCooldown(Level world, long lastTicked) {
        return world.m_46467_() - lastTicked < 20L;
    }

    protected DamageSource getDamageSource() {
        return CommonUtil.SPIKE_DAMAGE;
    }
}

