/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.configured;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.selene.util.WoodSetType;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.common.configs.ConfigHandler;
import net.mehvahdjukaar.supplementaries.integration.configured.CustomConfigSelectScreen;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CustomConfigScreen
extends ConfigScreen {
    private final ResourceLocation background;
    private static final Map<String, ItemStack> ICONS = new HashMap<String, ItemStack>();
    public static final ItemStack MAIN_ICON = new ItemStack((ItemLike)ModRegistry.GLOBE_ITEM.get());
    @Nullable
    private static final Field FOLDER_LABEL;
    @Nullable
    private static final Field BUTTON_ON_PRESS;
    @Nullable
    private static final Field FOLDER_ENTRY;
    @Nullable
    private static final Method SAVE_CONFIG;
    @Nullable
    private static final Field CONFIG_VALUE_HOLDER;
    @Nullable
    private static final Field BOOLEAN_ITEM_BUTTON;
    private int ticks = 0;

    private ItemStack getIcon(String name) {
        String formatted;
        Item item2;
        if (!ICONS.containsKey(name) && (item2 = (Item)ForgeRegistries.ITEMS.getValue(Supplementaries.res(formatted = name.toLowerCase(Locale.ROOT).replace(" ", "_")))) != Items.f_41852_) {
            CustomConfigScreen.addIcon(name, (ItemLike)item2);
        }
        return ICONS.getOrDefault(name, MAIN_ICON);
    }

    @Nullable
    private static Method findMethodOrNull(Class<?> c, String methodName) {
        Method field = null;
        try {
            field = ObfuscationReflectionHelper.findMethod(c, (String)methodName, (Class[])new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    @Nullable
    private static Field findFieldOrNull(Class<?> c, String fieldName) {
        Field field = null;
        try {
            field = ObfuscationReflectionHelper.findField(c, (String)fieldName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    private static void addIcon(String s, ItemLike i) {
        ICONS.put(s, new ItemStack(i));
    }

    private CustomConfigScreen(Screen parent, Component title, ModConfig config, ResourceLocation background, ConfigScreen.FolderEntry folderEntry) {
        this(parent, title, config, background);
        try {
            FOLDER_ENTRY.set((Object)this, folderEntry);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CustomConfigScreen(Screen parent, Component title, ModConfig config, ResourceLocation background) {
        super(parent, title, config, background);
        this.background = background;
    }

    protected void m_7856_() {
        super.m_7856_();
        boolean reg2 = this.config == ConfigHandler.REGISTRY_CONFIG_OBJECT && !this.folderEntry.isRoot();
        this.list.m_5988_(this.replaceItems(this.list.m_6702_(), reg2));
        Collection<ListMenuScreen.Item> temp = this.replaceItems(this.entries, reg2);
        this.entries = new ArrayList<ListMenuScreen.Item>(temp);
        if (this.saveButton != null && SAVE_CONFIG != null && BUTTON_ON_PRESS != null) {
            try {
                Button.OnPress press = this::saveButtonAction;
                BUTTON_ON_PRESS.set(this.saveButton, press);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Collection<ListMenuScreen.Item> replaceItems(Collection<ListMenuScreen.Item> originals, boolean fancyBooleans) {
        ArrayList<ListMenuScreen.Item> newList = new ArrayList<ListMenuScreen.Item>();
        for (ListMenuScreen.Item c : originals) {
            ConfigScreen.BooleanItem b;
            Object wrapper;
            if (c instanceof ConfigScreen.FolderItem) {
                ConfigScreen.FolderItem f = (ConfigScreen.FolderItem)c;
                wrapper = this.wrapFolderItem(f);
                if (wrapper != null) {
                    newList.add((ListMenuScreen.Item)wrapper);
                    continue;
                }
            } else if (c instanceof ConfigScreen.BooleanItem && (wrapper = this.wrapBooleanItem(b = (ConfigScreen.BooleanItem)c, fancyBooleans)) != null) {
                newList.add((ListMenuScreen.Item)wrapper);
                continue;
            }
            newList.add(c);
        }
        return newList;
    }

    public void saveButtonAction(Button button) {
        if (this.config != null) {
            try {
                SAVE_CONFIG.invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isChanged(this.folderEntry)) {
                if (this.config == ConfigHandler.SERVER_CONFIG_OBJECT) {
                    ConfigHandler.clientRequestServerConfigReload();
                } else if (this.config == ConfigHandler.CLIENT_CONFIG_OBJECT) {
                    ClientConfigs.cached.refresh();
                }
            }
        }
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (ScreenUtil.isMouseWithin((int)(this.f_96543_ / 2 - 90), (int)2, (int)180, (int)16, (int)mouseX, (int)mouseY)) {
            this.m_96617_(matrixStack, this.f_96547_.m_92923_((FormattedText)new TranslatableComponent("supplementaries.gui.info"), 200), mouseX, mouseY);
        }
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_) + 35;
        this.f_96542_.m_115218_(MAIN_ICON, this.f_96543_ / 2 + titleWidth / 2 - 17, 2);
        this.f_96542_.m_115218_(MAIN_ICON, this.f_96543_ / 2 - titleWidth / 2, 2);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin((int)(this.f_96543_ / 2 - 90), (int)2, (int)180, (int)16, (int)((int)mouseX), (int)((int)mouseY))) {
            Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/supplementaries"));
            this.m_5561_(style);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_96624_() {
        super.m_96624_();
        ++this.ticks;
    }

    @Nullable
    public FolderWrapper wrapFolderItem(ConfigScreen.FolderItem old) {
        ConfigScreen.FolderEntry folderEntry = this.folderEntry;
        try {
            String oldName = old.getLabel();
            ConfigScreen.FolderEntry found = null;
            for (ConfigScreen.IEntry e : folderEntry.getEntries()) {
                if (!(e instanceof ConfigScreen.FolderEntry)) continue;
                ConfigScreen.FolderEntry f = (ConfigScreen.FolderEntry)e;
                String n = new TextComponent(ConfigScreen.createLabel((String)((String)FOLDER_LABEL.get(e)))).m_6111_();
                if (!n.equals(oldName)) continue;
                found = f;
            }
            if (found != null) {
                return new FolderWrapper(found, oldName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public BooleanWrapper wrapBooleanItem(ConfigScreen.BooleanItem old, boolean displayItem) {
        ConfigScreen.FolderEntry folderEntry = this.folderEntry;
        try {
            ConfigScreen.ValueHolder holder = (ConfigScreen.ValueHolder)CONFIG_VALUE_HOLDER.get(old);
            ConfigScreen.ValueEntry found = null;
            for (ConfigScreen.IEntry e : folderEntry.getEntries()) {
                ConfigScreen.ValueEntry value;
                if (!(e instanceof ConfigScreen.ValueEntry) || holder != (value = (ConfigScreen.ValueEntry)e).getHolder()) continue;
                found = value;
            }
            if (found != null) {
                return displayItem ? new BooleanWrapperItem((ConfigScreen.ValueHolder<Boolean>)holder) : new BooleanWrapper((ConfigScreen.ValueHolder<Boolean>)holder);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        CustomConfigScreen.addIcon("blocks", (ItemLike)Items.f_151003_);
        CustomConfigScreen.addIcon("entities", (ItemLike)Items.f_42649_);
        CustomConfigScreen.addIcon("general", (ItemLike)Items.f_41997_);
        CustomConfigScreen.addIcon("particles", (ItemLike)Items.f_42593_);
        CustomConfigScreen.addIcon("items", (ItemLike)Items.f_151049_);
        CustomConfigScreen.addIcon("spawns", (ItemLike)Items.f_42279_);
        CustomConfigScreen.addIcon("tweaks", (ItemLike)ModRegistry.WRENCH.get());
        CustomConfigScreen.addIcon("turn particles", (ItemLike)ModRegistry.TURN_TABLE.get());
        CustomConfigScreen.addIcon("captured mobs", (ItemLike)ModRegistry.CAGE_ITEM.get());
        CustomConfigScreen.addIcon("flag", (ItemLike)ModRegistry.FLAGS_ITEMS.get(DyeColor.WHITE).get());
        CustomConfigScreen.addIcon("way sign", (ItemLike)ModRegistry.SIGN_POST_ITEMS.get(WoodSetType.OAK_WOOD_TYPE));
        CustomConfigScreen.addIcon("bells tweaks", (ItemLike)Items.f_42777_);
        CustomConfigScreen.addIcon("cake tweaks", (ItemLike)Items.f_42502_);
        CustomConfigScreen.addIcon("axe dispenser behaviors", (ItemLike)Items.f_42391_);
        CustomConfigScreen.addIcon("hanging flower pots", (ItemLike)Items.f_42618_);
        CustomConfigScreen.addIcon("throwable bricks", (ItemLike)Items.f_42460_);
        CustomConfigScreen.addIcon("wall lantern", (ItemLike)Items.f_42778_);
        CustomConfigScreen.addIcon("placeable sticks", (ItemLike)Items.f_42398_);
        CustomConfigScreen.addIcon("placeable sticks", (ItemLike)Items.f_42398_);
        CustomConfigScreen.addIcon("brewing stand colors", (ItemLike)Items.f_42543_);
        CustomConfigScreen.addIcon("timber frame", (ItemLike)ModRegistry.TIMBER_BRACE_ITEM.get());
        CustomConfigScreen.addIcon("bottle xp", (ItemLike)Items.f_42612_);
        CustomConfigScreen.addIcon("map tweaks", (ItemLike)Items.f_42573_);
        CustomConfigScreen.addIcon("ceiling banners", (ItemLike)Items.f_42727_);
        CustomConfigScreen.addIcon("initialization", (ItemLike)ModRegistry.COG_BLOCK_ITEM.get());
        CustomConfigScreen.addIcon("zombie horse", (ItemLike)Items.f_42609_);
        CustomConfigScreen.addIcon("placeable gunpowder", (ItemLike)Items.f_42403_);
        CustomConfigScreen.addIcon("mixins", (ItemLike)Items.f_42155_);
        CustomConfigScreen.addIcon("server protection", (ItemLike)Items.f_42116_);
        CustomConfigScreen.addIcon("placeable books", (ItemLike)Items.f_42690_);
        CustomConfigScreen.addIcon("sign post", (ItemLike)ModRegistry.SIGN_POST_ITEMS.get(WoodSetType.OAK_WOOD_TYPE));
        CustomConfigScreen.addIcon("wattle and daub", (ItemLike)ModRegistry.DAUB_BRACE_ITEM.get());
        CustomConfigScreen.addIcon("shulker shell", (ItemLike)Items.f_42748_);
        CustomConfigScreen.addIcon("jar tab", (ItemLike)ModRegistry.JAR_ITEM.get());
        CustomConfigScreen.addIcon("custom configured screen", (ItemLike)ModRegistry.WRENCH.get());
        CustomConfigScreen.addIcon("dispensers", (ItemLike)Items.f_41855_);
        CustomConfigScreen.addIcon("hanging sign", (ItemLike)ModRegistry.HANGING_SIGNS_ITEMS.get(WoodSetType.OAK_WOOD_TYPE));
        CustomConfigScreen.addIcon("blue bomb", (ItemLike)ModRegistry.BOMB_BLUE_ITEM_ON.get());
        CustomConfigScreen.addIcon("dispensers", (ItemLike)Items.f_41855_);
        CustomConfigScreen.addIcon("cave urns", (ItemLike)ModRegistry.URN_ITEM.get());
        CustomConfigScreen.addIcon("structures", (ItemLike)Items.f_41995_);
        CustomConfigScreen.addIcon("soap", (ItemLike)ModRegistry.SOAP_BLOCK.get());
        CustomConfigScreen.addIcon("mob head tweaks", (ItemLike)Items.f_42678_);
        CustomConfigScreen.addIcon("conditional sign registration", (ItemLike)Items.f_42127_);
        FOLDER_LABEL = CustomConfigScreen.findFieldOrNull(ConfigScreen.FolderEntry.class, "label");
        BUTTON_ON_PRESS = CustomConfigScreen.findFieldOrNull(Button.class, "onPress");
        FOLDER_ENTRY = CustomConfigScreen.findFieldOrNull(ConfigScreen.class, "folderEntry");
        SAVE_CONFIG = CustomConfigScreen.findMethodOrNull(ConfigScreen.class, "saveConfig");
        CONFIG_VALUE_HOLDER = CustomConfigScreen.findFieldOrNull(ConfigScreen.ConfigItem.class, "holder");
        BOOLEAN_ITEM_BUTTON = CustomConfigScreen.findFieldOrNull(ConfigScreen.BooleanItem.class, "button");
    }

    private class FolderWrapper
    extends ConfigScreen.FolderItem {
        private final ItemStack icon;
        protected final Button button;
        private int ticks;
        private int lastTick;

        private FolderWrapper(ConfigScreen.FolderEntry folderEntry, String label) {
            super((ConfigScreen)CustomConfigScreen.this, folderEntry);
            this.ticks = 0;
            this.lastTick = 1;
            this.button = new Button(10, 5, 44, 20, (Component)new TextComponent(label).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.WHITE), onPress -> {
                MutableComponent newTitle = CustomConfigScreen.this.f_96539_.m_6879_().m_130946_(" > " + label);
                CustomConfigScreen.this.f_96541_.m_91152_((Screen)new CustomConfigScreen((Screen)CustomConfigScreen.this, (Component)newTitle, CustomConfigScreen.this.config, CustomConfigScreen.this.background, folderEntry));
            });
            this.icon = CustomConfigScreen.this.getIcon(label.toLowerCase(Locale.ROOT));
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.button);
        }

        public void m_6311_(PoseStack matrixStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (this.lastTick < CustomConfigScreen.this.ticks) {
                this.ticks = Math.max(0, this.ticks + (selected ? 1 : -2)) % 36;
            }
            this.lastTick = CustomConfigScreen.this.ticks;
            this.button.f_93620_ = left - 1;
            this.button.f_93621_ = top;
            this.button.m_93674_(width);
            this.button.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            int center = this.button.f_93620_ + width / 2;
            ItemRenderer renderer = CustomConfigScreen.this.f_96542_;
            float p = (float)Math.PI / 180;
            RendererUtil.renderGuiItemRelative(this.icon, center + 90 - 17, top + 2, renderer, (s, r) -> {
                if (this.ticks != 0) {
                    if (r.booleanValue()) {
                        s.m_85845_(Vector3f.f_122225_.m_122270_(((float)this.ticks + partialTicks) * p * 10.0f));
                    } else {
                        float scale = 1.0f + 0.1f * Mth.m_14031_((float)(((float)this.ticks + partialTicks) * p * 20.0f));
                        s.m_85841_(scale, scale, scale);
                    }
                }
            });
            RendererUtil.renderGuiItemRelative(this.icon, center - 90, top + 2, renderer, (s, r) -> {
                if (this.ticks != 0) {
                    if (r.booleanValue()) {
                        s.m_85845_(Vector3f.f_122225_.m_122270_(((float)this.ticks + partialTicks) * p * 10.0f));
                    } else {
                        float scale = 1.0f + 0.1f * Mth.m_14031_((float)(((float)this.ticks + partialTicks) * p * 20.0f));
                        s.m_85841_(scale, scale, scale);
                    }
                }
            });
        }
    }

    private class BooleanWrapper
    extends ConfigScreen.BooleanItem {
        private static final int ICON_WIDTH = 12;
        protected Button button;
        protected boolean active;
        protected int iconOffset;

        public BooleanWrapper(ConfigScreen.ValueHolder<Boolean> holder) {
            super((ConfigScreen)CustomConfigScreen.this, holder);
            this.active = false;
            this.iconOffset = 0;
            try {
                this.button = (Button)BOOLEAN_ITEM_BUTTON.get((Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.button.m_93666_((Component)new TextComponent(""));
        }

        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.button.m_93666_((Component)new TextComponent(""));
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)CustomConfigSelectScreen.ICONS_TEXTURES);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69482_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int iconX = this.iconOffset + (int)((double)this.button.f_93620_ + Math.ceil((float)(this.button.m_5711_() - 12) / 2.0f));
            int iconY = (int)((double)this.button.f_93621_ + Math.ceil((float)(this.button.m_93694_() - 12) / 2.0f));
            int u = (Boolean)this.holder.getValue() != false ? 12 : 0;
            GuiComponent.m_93143_((PoseStack)poseStack, (int)iconX, (int)iconY, (int)this.button.m_93252_(), (float)u, (float)0.0f, (int)12, (int)12, (int)64, (int)64);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public void onResetValue() {
            this.button.m_93666_((Component)new TextComponent(""));
        }
    }

    private class BooleanWrapperItem
    extends BooleanWrapper {
        private final ItemStack item;

        public BooleanWrapperItem(ConfigScreen.ValueHolder<Boolean> holder) {
            super(holder);
            this.item = CustomConfigScreen.this.getIcon(this.label.m_6111_().toLowerCase(Locale.ROOT));
            this.iconOffset = 7;
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            boolean on = (Boolean)this.holder.getValue();
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            int light = 0xF000F0;
            if (!on) {
                light = 0;
            }
            int center = (int)((float)this.button.f_93620_ + (float)this.button.m_5711_() / 2.0f);
            ItemRenderer renderer = CustomConfigScreen.this.f_96542_;
            RendererUtil.renderGuiItemRelative(this.item, center - 8 - this.iconOffset, top + 2, renderer, (a, b) -> {}, light, OverlayTexture.f_118083_);
        }

        @Override
        public void onResetValue() {
            this.button.m_93666_((Component)new TextComponent(""));
        }
    }
}

