/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import net.mehvahdjukaar.supplementaries.common.block.blocks.UrnBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.UrnBlockTile;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FallingUrnEntity
extends FallingBlockEntity {
    public FallingUrnEntity(EntityType<FallingUrnEntity> type, Level level) {
        super(type, level);
    }

    public FallingUrnEntity(Level level) {
        super((EntityType)ModRegistry.FALLING_URN.get(), level);
    }

    public FallingUrnEntity(Level level, BlockPos pos, BlockState blockState) {
        this(level);
        this.f_19850_ = true;
        this.f_19854_ = (double)pos.m_123341_() + 0.5;
        this.f_19855_ = pos.m_123342_();
        this.f_19856_ = (double)pos.m_123343_() + 0.5;
        this.m_6034_(this.f_19854_, this.f_19855_ + (double)((1.0f - this.m_20206_()) / 2.0f), this.f_19856_);
        this.m_20256_(Vec3.f_82478_);
        this.m_31959_(this.m_142538_());
        this.setBlockState(blockState);
        this.m_149656_(1.0f, 20);
    }

    public void setBlockState(BlockState state) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)state));
        tag.m_128405_("Time", this.f_31942_);
        this.m_7378_(tag);
    }

    public boolean m_6097_() {
        return true;
    }

    @Nullable
    public ItemEntity m_19998_(ItemLike pItem) {
        this.shatter();
        return null;
    }

    public boolean m_142535_(float height, float amount, DamageSource source) {
        boolean r = super.m_142535_(height, amount, source);
        if (this.m_20184_().m_82556_() > 0.25) {
            this.shatter();
            this.f_31947_ = true;
            this.m_146870_();
        } else if (!this.m_20067_()) {
            this.f_19853_.m_46796_(1045, this.m_142538_(), 0);
        }
        return r;
    }

    private void shatter() {
        BlockState state = this.m_31980_();
        CompoundTag tag = this.f_31944_;
        UrnBlockTile tile = null;
        BlockPos pos = this.m_142538_();
        if (tag != null && !tag.m_128456_()) {
            tile = new UrnBlockTile(pos, state);
            tile.m_142466_(tag);
        }
        Block.m_49881_((BlockState)state, (Level)this.f_19853_, (BlockPos)pos, tile, null, (ItemStack)ItemStack.f_41583_);
        this.f_19853_.m_5898_(null, 2001, pos, Block.m_49956_((BlockState)state));
        UrnBlock.spawnExtraBrokenParticles(state, pos, this.f_19853_);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        this.shatter();
        this.m_146870_();
        return true;
    }
}

