/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.WallLanternBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.world.generation.structure.RoadSignFeature;
import net.mehvahdjukaar.supplementaries.common.world.generation.structure.StructureLocator;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class BlockGeneratorBlockTile
extends BlockEntity {
    private boolean firstTick = true;
    public Pair<List<Pair<Integer, BlockPos>>, Boolean> threadResult = null;
    private static final BlockState trapdoor = Blocks.f_50217_.m_49966_();
    private static final BlockState lantern = (BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true));
    private static final BlockState lanternDown = Blocks.f_50681_.m_49966_();
    private static final BlockState fence = Blocks.f_50479_.m_49966_();
    private static final BlockState jar = lantern;
    private static final BlockState slab = Blocks.f_50399_.m_49966_();
    private static final BlockState log = Blocks.f_50005_.m_49966_();
    private static final BlockState stoneSlab = Blocks.f_50404_.m_49966_();
    private static final BlockState stone = Blocks.f_50069_.m_49966_();
    private static final BlockState stair = Blocks.f_50635_.m_49966_();
    private static final BlockState air = Blocks.f_50016_.m_49966_();
    private static final BlockState path = Blocks.f_152481_.m_49966_();
    private static final BlockState path_2 = Blocks.f_50471_.m_49966_();

    public BlockGeneratorBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.BLOCK_GENERATOR_TILE.get(), pos, state);
    }

    private double averageAngles(float a, float b) {
        a = (float)((double)a * Math.PI / 180.0);
        b = (float)((double)b * Math.PI / 180.0);
        return 57.29577951308232 * Mth.m_14136_((double)(Mth.m_14031_((float)a) + Mth.m_14031_((float)b)), (double)(Mth.m_14089_((float)a) + Mth.m_14089_((float)b)));
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, BlockGeneratorBlockTile tile) {
        block31: {
            BlockPos pos;
            ServerLevel world;
            if (pLevel == null || pLevel.f_46443_) {
                return;
            }
            if (tile.firstTick) {
                tile.firstTick = false;
                world = (ServerLevel)pLevel;
                pos = pPos.m_6625_(2);
                int posX = pos.m_123341_();
                int posZ = pos.m_123343_();
                Thread thread = new Thread(() -> {
                    try {
                        tile.threadResult = StructureLocator.find(world, posX, posZ, 2);
                    }
                    catch (Exception e) {
                        tile.failAndRemove(pLevel, pPos, e);
                    }
                });
                thread.start();
            }
            try {
                if (tile.threadResult == null) break block31;
                world = (ServerLevel)pLevel;
                pos = pPos.m_6625_(2);
                BlockState topState = trapdoor;
                Pair<List<Pair<Integer, BlockPos>>, Boolean> locateResult = tile.threadResult;
                List villages = (List)locateResult.getLeft();
                boolean inVillage = (Boolean)locateResult.getRight();
                if (inVillage) {
                    ResourceKey b = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)world.m_46857_(pos).getRegistryName());
                    BlockState replace = b == Biomes.f_48203_ ? path_2 : path;
                    BlockGeneratorBlockTile.replaceCobbleWithPath((Level)world, pos, replace);
                }
                if (villages.size() >= 1) {
                    BlockPos village2;
                    int dist2;
                    BlockPos village1;
                    int dist1;
                    Random rand = world.f_46441_;
                    boolean twoSigns = true;
                    if (villages.size() == 1 || 0.3 > (double)rand.nextFloat() && (Integer)((Pair)villages.get(0)).getLeft() > 192) {
                        dist1 = (Integer)((Pair)villages.get(0)).getLeft();
                        village1 = (BlockPos)((Pair)villages.get(0)).getRight();
                        dist2 = dist1;
                        village2 = village1;
                        twoSigns = false;
                    } else {
                        boolean inv = rand.nextBoolean();
                        dist1 = (Integer)((Pair)villages.get(inv ? 0 : 1)).getLeft();
                        village1 = (BlockPos)((Pair)villages.get(inv ? 0 : 1)).getRight();
                        dist2 = (Integer)((Pair)villages.get(inv ? 1 : 0)).getLeft();
                        village2 = (BlockPos)((Pair)villages.get(inv ? 1 : 0)).getRight();
                    }
                    world.m_7731_(pos, ((Block)ModRegistry.SIGN_POST.get()).m_49966_(), 3);
                    BlockEntity blockEntity = world.m_7702_(pos);
                    if (blockEntity instanceof SignPostBlockTile) {
                        boolean hasFirefly;
                        Direction backDir;
                        float yaw;
                        float diff;
                        SignPostBlockTile sign = (SignPostBlockTile)blockEntity;
                        sign.setHeldBlock(Blocks.f_50479_.m_49966_());
                        boolean left = rand.nextBoolean();
                        sign.up = true;
                        sign.leftUp = left;
                        sign.pointToward(village1, true);
                        sign.down = twoSigns;
                        sign.leftDown = left;
                        sign.pointToward(village2, false);
                        if (Math.abs(sign.yawUp - sign.yawDown) > 90.0f) {
                            sign.leftDown = !sign.leftDown;
                            sign.pointToward(village2, false);
                        }
                        if (ServerConfigs.cached.DISTANCE_TEXT) {
                            sign.textHolder.setLine(0, BlockGeneratorBlockTile.getSignText(dist1));
                            if (twoSigns) {
                                sign.textHolder.setLine(1, BlockGeneratorBlockTile.getSignText(dist2));
                            }
                        }
                        Direction sideDir = (diff = Mth.m_14118_((float)(yaw = Mth.m_14177_((float)(90.0f + (float)tile.averageAngles(-sign.yawUp + 180.0f, -sign.yawDown + 180.0f)))), (float)(backDir = Direction.m_122364_((double)yaw)).m_122435_())) < 0.0f ? backDir.m_122427_() : backDir.m_122428_();
                        ArrayList<Direction> lampDir = new ArrayList<Direction>();
                        lampDir.add(backDir.m_122424_());
                        lampDir.add(backDir.m_122424_());
                        lampDir.add(backDir.m_122424_());
                        if (Math.abs(diff) > 30.0f) {
                            lampDir.add(sideDir.m_122424_());
                        }
                        boolean hasGroundLantern = false;
                        ResourceKey biome = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)world.m_46857_(pos).getRegistryName());
                        boolean bl = hasFirefly = (BiomeDictionary.hasType((ResourceKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || BiomeDictionary.hasType((ResourceKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((ResourceKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY) ? 0.2f : 0.01f) > rand.nextFloat();
                        if (0.3 > (double)rand.nextFloat() && Mth.m_14145_((float)(sign.getPointingYaw(true) + 180.0f), (float)yaw) > 70.0f) {
                            BlockPos stonePos = pos.m_7495_().m_141952_(backDir.m_122436_());
                            if (rand.nextBoolean()) {
                                world.m_7731_(stonePos, stoneSlab, 2);
                            } else {
                                world.m_7731_(stonePos, (BlockState)stair.m_61124_((Property)StairBlock.f_56841_, (Comparable)sideDir), 2);
                            }
                            stonePos = stonePos.m_141952_(sideDir.m_122436_());
                            world.m_7731_(stonePos, stone, 2);
                            if (0.35 > (double)rand.nextFloat()) {
                                world.m_7731_(stonePos.m_7494_(), hasFirefly ? jar : lanternDown, 3);
                                hasGroundLantern = true;
                            }
                            if (!RoadSignFeature.isNotSolid((LevelAccessor)world, (stonePos = stonePos.m_141952_(sideDir.m_122436_())).m_7495_())) {
                                if (rand.nextBoolean()) {
                                    world.m_7731_(stonePos, stoneSlab, 2);
                                } else {
                                    world.m_7731_(stonePos, (BlockState)stair.m_61124_((Property)StairBlock.f_56841_, (Comparable)sideDir.m_122424_()), 2);
                                }
                            }
                        }
                        if (!hasGroundLantern) {
                            boolean doubleSided;
                            pos = pos.m_6630_(2);
                            BlockState light = hasFirefly ? jar : lantern;
                            Direction dir = (Direction)lampDir.get(rand.nextInt(lampDir.size()));
                            boolean bl2 = doubleSided = 0.25 > (double)rand.nextFloat();
                            if (doubleSided) {
                                dir = dir.m_122427_();
                            }
                            if (0.32 > (double)rand.nextFloat()) {
                                topState = 0.32 > (double)rand.nextFloat() ? trapdoor : air;
                                WallLanternBlock wl = (WallLanternBlock)ModRegistry.WALL_LANTERN.get();
                                wl.placeOn(lanternDown, pos.m_7495_(), dir, (Level)world);
                                if (doubleSided) {
                                    wl.placeOn(lanternDown, pos.m_7495_(), dir.m_122424_(), (Level)world);
                                }
                            } else {
                                boolean isTrapdoor;
                                boolean bl3 = isTrapdoor = 0.4 > (double)rand.nextFloat();
                                if (!isTrapdoor) {
                                    topState = fence;
                                }
                                if (doubleSided) {
                                    BlockPos backPos = pos.m_142300_(dir.m_122424_());
                                    world.m_7731_(backPos, isTrapdoor ? trapdoor : fence, 2);
                                    if (0.25 > (double)rand.nextFloat()) {
                                        topState = isTrapdoor ? slab : log;
                                    }
                                    world.m_7731_(backPos.m_7495_(), light, 3);
                                }
                                pos = pos.m_142300_(dir);
                                BlockState frontState = isTrapdoor ? trapdoor : fence;
                                world.m_7731_(pos, frontState, 2);
                                world.m_7731_(pos.m_7495_(), light, 3);
                            }
                        }
                    }
                } else {
                    ItemStack book = new ItemStack((ItemLike)Items.f_42614_);
                    CompoundTag com = new CompoundTag();
                    ListTag listTag = new ListTag();
                    listTag.add((Object)StringTag.m_129297_((String)"nothing here but monsters\n\n\n"));
                    com.m_128365_("pages", (Tag)listTag);
                    book.m_41751_(com);
                    BlockPos belowPos = pPos.m_6625_(2);
                    world.m_7731_(belowPos, (BlockState)((BlockState)((Block)ModRegistry.NOTICE_BOARD.get()).m_49966_().m_61124_((Property)NoticeBoardBlock.HAS_BOOK, (Comparable)Boolean.valueOf(true))).m_61124_((Property)NoticeBoardBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.m_122560_(world.f_46441_)), 3);
                    BlockEntity blockEntity = world.m_7702_(belowPos);
                    if (blockEntity instanceof NoticeBoardBlockTile) {
                        NoticeBoardBlockTile board = (NoticeBoardBlockTile)blockEntity;
                        board.setDisplayedItem(book);
                    }
                }
                world.m_7731_(pPos, topState, 3);
            }
            catch (Exception exception) {
                tile.failAndRemove(pLevel, pPos, exception);
            }
        }
    }

    private void failAndRemove(Level level, BlockPos pos, Exception e) {
        level.m_7471_(pos, false);
        Supplementaries.LOGGER.warn("failed to generate road sign at " + pos + ": " + e);
    }

    private static Component getSignText(int d) {
        int s = d < 100 ? 10 : (d < 2000 ? 100 : 1000);
        return new TranslatableComponent("message.supplementaries.road_sign", new Object[]{(d + s / 2) / s * s});
    }

    private static void replaceCobbleWithPath(Level world, BlockPos pos, BlockState path) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                BlockPos pathPos;
                BlockState state;
                if (Math.abs(i) == 2 && Math.abs(j) == 2 || i == 0 && j == 0 || !(state = world.m_8055_(pathPos = pos.m_142082_(i, -2, j))).m_60713_(Blocks.f_50652_) && !state.m_60713_(Blocks.f_50079_)) continue;
                world.m_7731_(pathPos, path, 2);
            }
        }
    }
}

