/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.ExpandedMapData;
import net.mehvahdjukaar.supplementaries.api.IRotatable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FenceMimicBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.framedblocks.FramedSignPost;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SignPostBlock
extends FenceMimicBlock
implements EntityBlock,
IRotatable {
    public SignPostBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!level.f_46443_) {
            SignPostBlockTile tile;
            ItemStack itemstack = player.m_21120_(handIn);
            Item item2 = itemstack.m_41720_();
            if (item2 instanceof MapItem) {
                MapItemSavedData mapItemSavedData = MapItem.m_42853_((ItemStack)itemstack, (Level)level);
                if (mapItemSavedData instanceof ExpandedMapData) {
                    ExpandedMapData data = (ExpandedMapData)mapItemSavedData;
                    data.toggleCustomDecoration((LevelAccessor)level, pos);
                }
                return InteractionResult.CONSUME;
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SignPostBlockTile && (tile = (SignPostBlockTile)blockEntity).isAccessibleBy(player)) {
                boolean isSneaking;
                boolean emptyHand = itemstack.m_41619_();
                boolean bl = isSneaking = player.m_6144_() && emptyHand;
                if (hit.m_82434_().m_122434_() != Direction.Axis.Y) {
                    InteractionResult result = tile.textHolder.playerInteract(level, pos, player, handIn, tile);
                    if (result != InteractionResult.PASS) {
                        return result;
                    }
                    if (isSneaking) {
                        boolean up;
                        double y = hit.m_82450_().f_82480_;
                        boolean bl2 = up = y % (double)((int)y) > 0.5;
                        if (up) {
                            tile.leftUp = !tile.leftUp;
                        } else {
                            tile.leftDown = !tile.leftDown;
                        }
                        tile.m_6596_();
                        level.m_7260_(pos, state, state, 3);
                        level.m_5594_(null, pos, SoundEvents.f_12017_, SoundSource.BLOCKS, 1.0f, 0.6f);
                        return InteractionResult.CONSUME;
                    }
                    if (item2 instanceof CompassItem) {
                        BlockPos pointingPos;
                        BlockPos blockPos = pointingPos = CompassItem.m_40736_((ItemStack)itemstack) ? this.getLodestonePos(level, itemstack) : this.getWorldSpawnPos(level);
                        if (pointingPos != null) {
                            boolean up;
                            double y = hit.m_82450_().f_82480_;
                            boolean bl3 = up = y % (double)((int)y) > 0.5;
                            if (up && tile.up) {
                                tile.pointToward(pointingPos, true);
                            } else if (!up && tile.down) {
                                tile.pointToward(pointingPos, false);
                            }
                            tile.m_6596_();
                            level.m_7260_(pos, state, state, 3);
                            return InteractionResult.CONSUME;
                        }
                        return InteractionResult.FAIL;
                    }
                    if (CompatHandler.framedblocks && tile.framed) {
                        boolean success = FramedSignPost.handleInteraction(tile, player, handIn, itemstack, level, pos);
                        if (success) {
                            return InteractionResult.CONSUME;
                        }
                    } else if (item2 instanceof SignPostItem) {
                        return InteractionResult.PASS;
                    }
                }
                tile.sendOpenGuiPacket(level, pos, player);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    private BlockPos getLodestonePos(Level world, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            Optional optional;
            boolean flag = tag.m_128441_("LodestonePos");
            boolean flag1 = tag.m_128441_("LodestoneDimension");
            if (flag && flag1 && (optional = CompassItem.m_40727_((CompoundTag)tag)).isPresent() && world.m_46472_() == optional.get()) {
                return NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LodestonePos"));
            }
        }
        return null;
    }

    @Nullable
    private BlockPos getWorldSpawnPos(Level world) {
        return world.m_6042_().m_63956_() ? new BlockPos(world.m_6106_().m_6789_(), world.m_6106_().m_6527_(), world.m_6106_().m_6526_()) : null;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SignPostBlockTile) {
            boolean up;
            SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
            double y = target.m_82450_().f_82480_;
            boolean bl = up = y % (double)((int)y) > 0.5;
            if (up && tile.up) {
                return new ItemStack((ItemLike)ModRegistry.SIGN_POST_ITEMS.get(tile.woodTypeUp));
            }
            if (!up && tile.down) {
                return new ItemStack((ItemLike)ModRegistry.SIGN_POST_ITEMS.get(tile.woodTypeDown));
            }
            return new ItemStack((ItemLike)tile.mimic.m_60734_());
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    @Override
    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        Object object = builder.m_78982_(LootContextParams.f_81462_);
        if (object instanceof SignPostBlockTile) {
            ItemStack s;
            SignPostBlockTile tile = (SignPostBlockTile)object;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(new ItemStack((ItemLike)tile.mimic.m_60734_()));
            if (tile.up) {
                s = new ItemStack((ItemLike)ModRegistry.SIGN_POST_ITEMS.get(tile.woodTypeUp));
                list.add(s);
            }
            if (tile.down) {
                s = new ItemStack((ItemLike)ModRegistry.SIGN_POST_ITEMS.get(tile.woodTypeDown));
                list.add(s);
            }
            return list;
        }
        return super.m_7381_(state, builder);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot) {
        return state;
    }

    @Override
    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        return Optional.of(state);
    }

    @Override
    public Optional<Direction> rotateOverAxis(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot, Direction axis, @Nullable Vec3 hit) {
        boolean success = false;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SignPostBlockTile) {
            float angle;
            SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
            boolean simple = hit == null;
            boolean ccw = rot.equals((Object)Rotation.COUNTERCLOCKWISE_90);
            float f = simple ? (float)(ccw ? 90 : -90) : (angle = 22.5f * (float)(ccw ? 1 : -1));
            if (simple) {
                if (tile.rotateSign(true, angle, false)) {
                    success = true;
                }
                if (tile.rotateSign(false, angle, false)) {
                    success = true;
                }
            } else {
                boolean up;
                boolean bl = up = hit.f_82480_ % (double)((int)hit.f_82480_) > 0.5;
                if (tile.rotateSign(up, angle, true)) {
                    success = true;
                } else if (tile.rotateSign(!up, angle, true)) {
                    success = true;
                }
            }
            if (success) {
                tile.m_6596_();
                if (world instanceof Level) {
                    Level level = (Level)world;
                    level.m_7260_(pos, state, state, 3);
                }
                return Optional.of(Direction.UP);
            }
        }
        return Optional.empty();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new SignPostBlockTile(pPos, pState);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockUtils.addOptionalOwnership(placer, worldIn, pos);
    }
}

