/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class FeatherParticle
extends TextureSheetParticle {
    private final float rotSpeed;
    private boolean fallingAnim = false;
    private int animationOffset;
    private float rotOffset = 0.0f;
    private int groundTime = 0;

    private FeatherParticle(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double speedX, double speedY, double speedZ) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn);
        this.f_107663_ = (float)((double)this.f_107663_ * (1.3125 + (double)this.f_107223_.nextFloat() * 0.15));
        this.f_107225_ = 360 + this.f_107223_.nextInt(60);
        this.rotSpeed = 2.0f * (0.045f + this.f_107223_.nextFloat() * 0.08f) + ((float)speedY - 0.03f);
        this.animationOffset = (int)(this.f_107223_.nextFloat() * ((float)Math.PI * 2) / this.rotSpeed);
        this.f_107215_ = speedX + ((double)this.f_107223_.nextFloat() * 2.0 - 1.0) * (double)0.008f;
        this.f_107216_ = speedY;
        this.f_107217_ = speedZ + ((double)this.f_107223_.nextFloat() * 2.0 - 1.0) * (double)0.008f;
        this.f_107226_ = 0.007f;
    }

    public void setRotOffset(int spriteIndex) {
        int[] offsets = new int[]{-45, 0, 16};
        this.rotOffset = (float)((double)offsets[spriteIndex] * Math.PI / 180.0);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (++this.f_107224_ >= this.f_107225_ || this.groundTime > 20) {
            this.m_107274_();
        } else {
            this.f_107216_ -= 0.04 * (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ *= (double)this.f_172258_;
            this.f_107216_ *= (double)this.f_172258_;
            this.f_107217_ *= (double)this.f_172258_;
            if (this.f_107218_ && this.f_107216_ > 0.0) {
                this.f_107218_ = false;
            }
            if (!this.f_107218_) {
                if (!this.fallingAnim) {
                    float rot = (float)((double)((float)(this.f_107224_ + this.animationOffset) * this.rotSpeed) % (Math.PI * 2));
                    if (this.f_107216_ <= 0.0 && rot > 0.0f && (double)rot < 0.01 + (double)(this.rotSpeed * 2.0f)) {
                        this.fallingAnim = true;
                        if (this.f_107204_ > 6.0f) {
                            // empty if block
                        }
                        this.animationOffset = this.f_107224_;
                    }
                    this.f_107204_ = this.f_107231_;
                    this.f_107231_ = rot;
                } else {
                    int t = this.f_107224_ - this.animationOffset;
                    double freq = 1.0f - this.rotSpeed;
                    double k = 20.0;
                    float min = (float)(freq / 2.0);
                    float amp = (float)((freq - (double)min) * Math.exp((double)(-t) / k)) + min;
                    float w = (float)((double)this.rotSpeed / freq);
                    this.f_107204_ = this.f_107231_;
                    this.f_107231_ = Mth.m_14031_((float)((float)t * w)) * amp;
                }
            } else {
                ++this.groundTime;
                this.f_107204_ = this.f_107231_;
                this.f_107216_ = 0.0;
            }
        }
    }

    public void m_5744_(VertexConsumer builder, Camera info, float partialTicks) {
        Quaternion quaternion;
        Vec3 vector3d = info.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vector3d.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vector3d.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vector3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = info.m_90591_();
        } else {
            quaternion = new Quaternion(info.m_90591_());
            float p = 57.29578f;
            float f3 = Mth.m_14189_((float)partialTicks, (float)((this.rotOffset + this.f_107204_) * p), (float)((this.rotOffset + this.f_107231_) * p));
            quaternion.m_80148_(Vector3f.f_122227_.m_122270_(f3 / p));
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.m_122251_(quaternion);
            vector3f.m_122261_(f4);
            vector3f.m_122272_(f, f1, f2);
        }
        float f7 = this.m_5970_();
        float f8 = this.m_5952_();
        float f5 = this.m_5951_();
        float f6 = this.m_5950_();
        int j = this.m_6355_(partialTicks);
        double offset = 0.125;
        builder.m_5483_((double)avector3f[0].m_122239_(), (double)avector3f[0].m_122260_() + offset, (double)avector3f[0].m_122269_()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        builder.m_5483_((double)avector3f[1].m_122239_(), (double)avector3f[1].m_122260_() + offset, (double)avector3f[1].m_122269_()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        builder.m_5483_((double)avector3f[2].m_122239_(), (double)avector3f[2].m_122260_() + offset, (double)avector3f[2].m_122269_()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        builder.m_5483_((double)avector3f[3].m_122239_(), (double)avector3f[3].m_122260_() + offset, (double)avector3f[3].m_122269_()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FeatherParticle particle2 = new FeatherParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            particle2.m_107253_(1.0f, 1.0f, 1.0f);
            int i = particle2.f_107223_.nextInt(3);
            particle2.setRotOffset(i);
            particle2.m_108337_(this.spriteSet.m_5819_(i, 2));
            return particle2;
        }
    }
}

