/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.world;

import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSerializer.class})
public abstract class MixinChunkSerializer {
    @Inject(method={"deserialize(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/world/poi/PointOfInterestStorage;Lnet/minecraft/util/math/ChunkPos;Lnet/minecraft/nbt/NbtCompound;)Lnet/minecraft/world/chunk/ProtoChunk;"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/chunk/ChunkManager;getLightingProvider()Lnet/minecraft/world/chunk/light/LightingProvider;", ordinal=0)})
    private static void loadLightmaps(ServerLevel world, PoiManager poiStorage, ChunkPos pos, CompoundTag nbt, CallbackInfoReturnable<ProtoChunk> ci) {
        if (nbt.m_128471_("isLightOn") || !nbt.m_128425_("Heightmaps", 10)) {
            return;
        }
        ListTag sections = nbt.m_128437_("Sections", 10);
        ThreadedLevelLightEngine lightingProvider = world.m_7726_().m_7827_();
        boolean hasSkyLight = world.m_6042_().m_63935_();
        lightingProvider.m_6462_(pos, true);
        for (int i = 0; i < sections.size(); ++i) {
            CompoundTag section = sections.m_128728_(i);
            byte y = section.m_128445_("Y");
            if (section.m_128425_("BlockLight", 7)) {
                lightingProvider.m_5687_(LightLayer.BLOCK, SectionPos.m_123196_((ChunkPos)pos, (int)y), new DataLayer(section.m_128463_("BlockLight")), true);
            }
            if (!hasSkyLight || !section.m_128425_("SkyLight", 7)) continue;
            lightingProvider.m_5687_(LightLayer.SKY, SectionPos.m_123196_((ChunkPos)pos, (int)y), new DataLayer(section.m_128463_("SkyLight")), true);
        }
    }
}

