/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.mixin.config;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import malte0811.ferritecore.mixin.config.FerriteConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public abstract class FerriteMixinConfig
implements IMixinConfigPlugin {
    protected static final Logger LOGGER = LogManager.getLogger((String)"ferritecore-mixin");
    private String prefix = null;
    private final FerriteConfig.Option enableOption;

    protected FerriteMixinConfig(FerriteConfig.Option enableOption) {
        this.enableOption = enableOption;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        Preconditions.checkState((boolean)mixinClassName.startsWith(this.prefix), (Object)("Unexpected prefix on " + mixinClassName));
        if (!this.enableOption.isEnabled()) {
            LOGGER.warn("Mixin " + mixinClassName + " is disabled by config");
            return false;
        }
        return true;
    }

    public void onLoad(String mixinPackage) {
        this.prefix = mixinPackage + ".";
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

