/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.StringUtils;

public class AssetGenerators {

    public static class BlockstateBuilder {
        private final Block block;
        private final Map<Map<Property<?>, Comparable<?>>, ModelConfiguration> blockModelMappings = new HashMap();

        public BlockstateBuilder(Block block) {
            this.block = block;
        }

        public static BlockstateBuilder forAllStatesExcept(Block block, Function<BlockState, ModelConfiguration> modelLocationProvider, Property<?> ... ignored) {
            BlockstateBuilder builder = new BlockstateBuilder(block);
            BlockState defaultState = block.m_49966_();
            HashSet seen = new HashSet();
            block0: for (BlockState fullState : block.m_49965_().m_61056_()) {
                LinkedHashMap propertyValues = Maps.newLinkedHashMap((Map)fullState.m_61148_());
                for (Property<?> p : ignored) {
                    if (propertyValues.get(p) != defaultState.m_61143_(p)) continue block0;
                    propertyValues.remove(p);
                }
                builder.setModel(propertyValues, modelLocationProvider.apply(fullState));
            }
            return builder;
        }

        public BlockstateBuilder setModel(Map<Property<?>, Comparable<?>> properties, ModelConfiguration modelLocation) {
            this.blockModelMappings.put(properties, modelLocation);
            return this;
        }

        public JsonObject build() {
            JsonObject main = new JsonObject();
            JsonObject variants = new JsonObject();
            for (Map.Entry<Map<Property<?>, Comparable<?>>, ModelConfiguration> entry : this.blockModelMappings.entrySet()) {
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<Property<?>, Comparable<?>> v : entry.getKey().entrySet()) {
                    builder.append(v.getKey().m_61708_()).append("=").append(v.getValue());
                }
                variants.add(builder.toString(), (JsonElement)entry.getValue().toJson());
            }
            main.add("variants", (JsonElement)variants);
            return main;
        }
    }

    public static class ModelConfiguration {
        public final ResourceLocation modelLocation;
        public int xRot = 0;
        public int yRot = 0;
        public boolean uvLock = false;

        public ModelConfiguration(ResourceLocation modelLocation) {
            this.modelLocation = modelLocation;
        }

        public JsonObject toJson() {
            JsonObject model = new JsonObject();
            model.addProperty("model", this.modelLocation.toString());
            if (this.xRot != 0) {
                model.addProperty("x", (Number)this.xRot);
            }
            if (this.yRot != 0) {
                model.addProperty("y", (Number)this.xRot);
            }
            if (this.uvLock) {
                model.addProperty("uvlock", Boolean.valueOf(true));
            }
            return model;
        }
    }

    public static class SimpleModelBuilder {
        private final ResourceLocation parent;
        private final Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();

        public SimpleModelBuilder(ResourceLocation parent) {
            this.parent = parent;
        }

        public SimpleModelBuilder texture(String name, ResourceLocation texture) {
            this.textures.put(name, texture);
            return this;
        }

        public JsonElement build() {
            JsonObject json = new JsonObject();
            json.addProperty("parent", this.parent.toString());
            JsonObject text = new JsonObject();
            this.textures.forEach((key, value) -> text.addProperty(key, value.toString()));
            json.add("textures", (JsonElement)text);
            return json;
        }
    }

    public static class LangBuilder {
        private final Map<String, String> entries = new LinkedHashMap<String, String>();

        public static String getReadableName(String name) {
            return Arrays.stream(name.replace(":", "_").split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        }

        public void addGenericEntry(String key, String translation) {
            this.entries.put(key, translation);
        }

        public void addEntry(Block block, String translation) {
            this.entries.put(block.m_7705_(), translation);
        }

        public void addEntry(Item item, String translation) {
            this.entries.put(item.m_5524_(), translation);
        }

        public void addEntry(EntityType<?> entityType, String translation) {
            this.entries.put(entityType.m_20675_(), translation);
        }

        public JsonElement build() {
            JsonObject json = new JsonObject();
            for (Map.Entry<String, String> e : this.entries.entrySet()) {
                json.addProperty(e.getKey(), e.getValue());
            }
            return json;
        }
    }
}

