/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.fluids;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.fluids.FluidTextures;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.util.DispenserHelper;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;

public class SoftFluidRegistry {
    private static final HashMap<String, SoftFluid> ID_MAP = new HashMap();
    private static final HashMap<Item, SoftFluid> ITEM_MAP = new HashMap();
    private static final HashMap<Fluid, SoftFluid> FLUID_MAP = new HashMap();
    public static final SoftFluid EMPTY = new SoftFluid(new SoftFluid.Builder(Fluids.f_76191_));
    public static final SoftFluid WATER = SoftFluidRegistry.makeSF(new SoftFluid.Builder((Fluid)Fluids.f_76193_).containerItem("xercamod:item_glass_of_water", "xercamod:item_glass", 4).containerItem("tea_kettle:water_kettle", "tea_kettle:empty_kettle", 4).drink(Items.f_42589_));
    public static final SoftFluid LAVA = SoftFluidRegistry.makeSF(new SoftFluid.Builder((Fluid)Fluids.f_76195_).noTint().bottle("alexsmobs:lava_bottle").bucket(Items.f_42448_).setBucketSounds(SoundEvents.f_11783_, SoundEvents.f_11780_));
    public static final SoftFluid HONEY = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.HONEY_TEXTURE, FluidTextures.HONEY_TEXTURE, "honey").translationKey("fluid.supplementaries.honey").noTint().drink(Items.f_42787_).setSoundsForCategory(SoundEvents.f_11967_, SoundEvents.f_11964_, Items.f_42590_).emptyHandContainerItem(Items.f_42788_, 4).setSoundsForCategory(SoundEvents.f_11967_, SoundEvents.f_11964_, Items.f_41852_).copyTexturesFrom("create:honey").addEqFluid("create:honey").addEqFluid("cyclic:honey").addEqFluid("inspirations:honey"));
    public static final SoftFluid MILK = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.MILK_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "milk").bucket(Items.f_42455_).noTint().food(Items.f_42455_).translationKey("fluid.supplementaries.milk").copyFlowingTextureFrom("create:milk").addEqFluid("create:milk").addEqFluid("inspirations:milk").bottle("farmersdelight:milk_bottle").bottle("neapolitan:milk_bottle").bottle("fluffy_farmer:bottle_of_milk").bottle("vanillacookbook:milk_bottle").bottle("simplefarming:milk_bottle").bottle("farmersdelight:milk_bottle").containerItem("xercamod:item_glass_of_milk", "xercamod:item_glass", 4).containerItem("frozenup:mug_of_milk", "frozenup:empty_mug", 4));
    public static final SoftFluid MUSHROOM_STEW = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.SOUP_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "mushroom_stew").color(16756105).stew(Items.f_42400_).translationKey(Items.f_42400_.m_5524_()).addEqFluid("inspirations:mushroom_stew").copyFlowingTextureFrom("inspirations:mushroom_stew"));
    public static final SoftFluid BEETROOT_SOUP = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.SOUP_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "beetroot_soup").color(13186100).stew(Items.f_42734_).translationKey(Items.f_42734_.m_5524_()).addEqFluid("inspirations:beetroot_soup").copyFlowingTextureFrom("inspirations:beetroot_soup"));
    public static final SoftFluid RABBIT_STEW = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.SOUP_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "rabbit_stew").color(16748623).stew(Items.f_42699_).translationKey(Items.f_42699_.m_5524_()).addEqFluid("inspirations:rabbit_stew").copyFlowingTextureFrom("inspirations:rabbit_stew"));
    public static final SoftFluid SUS_STEW = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.SOUP_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "suspicious_stew").color(12249183).keepNBTFromItem("Effects").stew(Items.f_42718_).translationKey(Items.f_42718_.m_5524_()).copyFlowingTextureFrom("inspirations:mushroom_stew"));
    public static final SoftFluid POTION = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.POTION_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "potion").color(PotionUtils.m_43559_((Potion)Potions.f_43598_)).keepNBTFromItem("Potion", "Bottle", "CustomPotionEffects").translationKey(Items.f_42589_.m_5524_()).drink(Items.f_42589_).bottle(Items.f_42736_).bottle(Items.f_42739_).containerItem("minecraft:splash_potion", "inspirations:splash_bottle", 1).containerItem("minecraft:lingering_potion", "inspirations:lingering_bottle", 1).copyTexturesFrom("create:potion").addEqFluid("create:potion").addEqFluid("cofh_core:potion").addEqFluid("immersiveengineering:potion"));
    public static final SoftFluid DRAGON_BREATH = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.DRAGON_BREATH_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "dragon_breath").color(0xFF33FF).luminosity(3).translationKey(Items.f_42735_.m_5524_()).bottle(Items.f_42735_));
    public static final SoftFluid XP = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.XP_TEXTURE, FluidTextures.XP_TEXTURE_FLOW, "experience").translationKey("fluid.supplementaries.experience").luminosity(5).noTint().copyTexturesFrom("cyclic:xpjuice").addEqFluid("cyclic:xpjuice").bottle(Items.f_42612_));
    public static final SoftFluid SLIME = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.SLIME_TEXTURE, FluidTextures.SLIME_TEXTURE, "slime").emptyHandContainerItem(Items.f_42518_, 1).noTint().setSoundsForCategory(SoundEvents.f_12392_, SoundEvents.f_12389_, Items.f_41852_).addEqFluid("cyclic:slime").translationKey("fluid.supplementaries.slime"));
    public static final SoftFluid GHAST_TEAR = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.MILK_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "ghast_tear").color(0xBFF0F0).emptyHandContainerItem(Items.f_42586_, 1).translationKey("item.minecraft.ghast_tear"));
    public static final SoftFluid MAGMA_CREAM = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.MAGMA_TEXTURE, FluidTextures.MAGMA_TEXTURE_FLOW, "magma_cream").emptyHandContainerItem(Items.f_42542_, 1).color(16752896).setSoundsForCategory(SoundEvents.f_12392_, SoundEvents.f_12389_, Items.f_41852_).translationKey("item.minecraft.magma_cream"));

    public static Collection<SoftFluid> getFluids() {
        return ID_MAP.values();
    }

    public static SoftFluid get(String id) {
        return ID_MAP.getOrDefault(id, EMPTY);
    }

    public static SoftFluid fromForgeFluid(Fluid fluid) {
        return FLUID_MAP.getOrDefault(fluid, EMPTY);
    }

    @Nonnull
    public static SoftFluid fromItem(Item filledContainerItem) {
        return ITEM_MAP.getOrDefault(filledContainerItem, EMPTY);
    }

    public static boolean addContainerToSoftFluid(String softFluidID, Item emptyContainer, Item filledContainer, int itemCapacity, @Nullable SoundEvent fillSound, @Nullable SoundEvent emptySound) {
        SoftFluid s = SoftFluidRegistry.get(softFluidID);
        if (!s.isEmpty() && filledContainer != Items.f_41852_) {
            SoftFluid.FilledContainerCategory c = s.getFilledContainersMap().computeIfAbsent(emptyContainer, a -> new SoftFluid.FilledContainerCategory(itemCapacity));
            c.setCapacity(itemCapacity);
            c.addItem(filledContainer);
            if (fillSound != null && emptySound != null) {
                c.setSounds(fillSound, emptySound);
            }
            return true;
        }
        return false;
    }

    public static SoftFluid makeSF(SoftFluid.Builder builder) {
        if (builder.isDisabled) {
            return null;
        }
        return new SoftFluid(builder);
    }

    public static SoftFluid register(SoftFluid s) {
        if (s.isDisabled()) {
            return s;
        }
        for (Fluid f : s.getEquivalentFluids()) {
            if (!FLUID_MAP.containsKey(f)) continue;
            SoftFluid old = FLUID_MAP.get(f);
            if (old.isCustom) continue;
            ID_MAP.remove(old.getID());
            ITEM_MAP.remove(old.getFilledContainer(Items.f_42446_));
        }
        SoftFluidRegistry.registerUnchecked(s);
        return s;
    }

    private static void registerUnchecked(SoftFluid ... fluids) {
        Arrays.stream(fluids).forEach(s -> {
            s.getEquivalentFluids().forEach(f -> FLUID_MAP.put((Fluid)f, (SoftFluid)s));
            s.getAllFilledContainers().forEach(i -> ITEM_MAP.put((Item)i, (SoftFluid)s));
            ID_MAP.put(s.getID(), (SoftFluid)s);
            DispenserHelper.registerFluidBehavior(s);
        });
    }

    private static void convertAndRegisterAllForgeFluids() {
        for (Fluid f : ForgeRegistries.FLUIDS) {
            try {
                if (f == null || f instanceof FlowingFluid && ((FlowingFluid)f).m_5613_() != f || f instanceof ForgeFlowingFluid.Flowing || f == Fluids.f_76191_ || FLUID_MAP.containsKey(f)) continue;
                SoftFluidRegistry.registerUnchecked(new SoftFluid(new SoftFluid.Builder(f)));
            }
            catch (Exception exception) {}
        }
    }

    public static void init() {
        SoftFluidRegistry.registerUnchecked(WATER, LAVA, HONEY, MILK, MUSHROOM_STEW, MAGMA_CREAM, SUS_STEW, BEETROOT_SOUP, RABBIT_STEW, POTION, DRAGON_BREATH, XP, SLIME, GHAST_TEAR);
        SoftFluidRegistry.convertAndRegisterAllForgeFluids();
    }
}

