/*
 * Decompiled with CFR 0.152.
 */
package cobbled_paths.block;

import cobbled_paths.RegUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BetterPathBlock
extends DirtPathBlock {
    private final Supplier<Block> blockSupplier;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public final Map<Item, Block> TRANSFORMS;

    public BetterPathBlock(BlockBehaviour.Properties properties) {
        this(properties, RegUtil.getVanillaBlockSupplier(new ResourceLocation("minecraft", "dirt")));
    }

    public BetterPathBlock(BlockBehaviour.Properties properties, Supplier<Block> blockSupplier) {
        this(properties, blockSupplier, new HashMap<Item, Block>());
    }

    public BetterPathBlock(BlockBehaviour.Properties properties, Supplier<Block> blockSupplier, Map<Item, Block> transforms) {
        super(properties);
        this.TRANSFORMS = transforms;
        this.blockSupplier = blockSupplier;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        ItemStack heldItemStack = player.m_21120_(hand);
        Item heldItem = heldItemStack.m_41720_();
        Block toTransform = this.TRANSFORMS.get(heldItem);
        if (toTransform instanceof BetterPathBlock) {
            BetterPathBlock betterPathBlock = (BetterPathBlock)toTransform;
            BlockState outState = betterPathBlock.m_49966_();
            outState = betterPathBlock.updateBlockState(outState, (LevelReader)level, pos);
            level.m_7731_(pos, outState, 11);
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        if (!this.m_49966_().m_60710_((LevelReader)blockPlaceContext.m_43725_(), blockPlaceContext.m_8083_())) {
            return Block.m_49897_((BlockState)this.m_49966_(), (BlockState)this.blockSupplier.get().m_49966_(), (Level)blockPlaceContext.m_43725_(), (BlockPos)blockPlaceContext.m_8083_());
        }
        Level blockGetter = blockPlaceContext.m_43725_();
        BlockState stateOut = this.m_49966_();
        stateOut = this.updateBlockState(stateOut, (LevelReader)blockGetter, blockPlaceContext.m_8083_());
        return stateOut;
    }

    public boolean hasBelow(BlockGetter blockGetter, BlockPos blockPos) {
        return Block.m_49918_((VoxelShape)blockGetter.m_8055_(blockPos).m_60816_(blockGetter, blockPos), (Direction)Direction.UP);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        blockState = this.updateBlockState(blockState, (LevelReader)levelAccessor, blockPos);
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public BlockState updateBlockState(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockPos nPos = blockPos.m_142127_();
        BlockPos sPos = blockPos.m_142128_();
        BlockPos ePos = blockPos.m_142126_();
        BlockPos wPos = blockPos.m_142125_();
        BlockPos dPos = blockPos.m_7495_();
        boolean hasBelow = this.hasBelow((BlockGetter)levelReader, dPos);
        boolean n = levelReader.m_8055_(nPos.m_7495_()).m_60734_() instanceof DirtPathBlock;
        boolean s = levelReader.m_8055_(sPos.m_7495_()).m_60734_() instanceof DirtPathBlock;
        boolean e = levelReader.m_8055_(ePos.m_7495_()).m_60734_() instanceof DirtPathBlock;
        boolean w = levelReader.m_8055_(wPos.m_7495_()).m_60734_() instanceof DirtPathBlock;
        return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(n && hasBelow))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(s && hasBelow))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(e && hasBelow))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(w && hasBelow));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST});
    }

    public void m_7458_(BlockState arg, ServerLevel arg2, BlockPos arg3, Random random) {
        this.turnToOriginal(arg, (Level)arg2, arg3);
    }

    public void turnToOriginal(BlockState blockState, Level level, BlockPos blockPos) {
        level.m_46597_(blockPos, BetterPathBlock.m_49897_((BlockState)blockState, (BlockState)this.blockSupplier.get().m_49966_(), (Level)level, (BlockPos)blockPos));
    }
}

