/*
 * Decompiled with CFR 0.152.
 */
package be.florens.expandability.mixin.swimming;

import be.florens.expandability.EventDispatcher;
import be.florens.expandability.EventResult;
import be.florens.expandability.Util;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getFluidHeight(Lnet/minecraft/tags/Tag;)D"))
    private double setFluidHeight(LivingEntity entity, Tag<Fluid> tag) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            EventResult shouldSwim = EventDispatcher.onPlayerSwim(player);
            return Util.processEventResult(shouldSwim, 1.0, 0.0, () -> player.m_20120_(tag));
        }
        return entity.m_20120_(tag);
    }

    @Redirect(method={"travel", "aiStep", "checkFallDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWater()Z"))
    private boolean setInWater(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return Util.processEventResult(EventDispatcher.onPlayerSwim(player), () -> ((Player)player).m_20069_());
        }
        return entity.m_20069_();
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    private void resetFallHeight(CallbackInfo info) {
        Player player;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && EventDispatcher.onPlayerSwim(player = (Player)livingEntityMixin) == EventResult.SUCCESS) {
            this.f_19789_ = 0.0f;
        }
    }

    @Redirect(method={"travel"}, allow=2, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isFree(DDD)Z"))
    private boolean cancelLeaveFluidAssist(LivingEntity entity, double x, double y, double z) {
        Player player;
        if (entity instanceof Player && EventDispatcher.onPlayerSwim(player = (Player)entity) == EventResult.SUCCESS) {
            return false;
        }
        return entity.m_20229_(x, y, z);
    }
}

