/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLDesertMountains
extends TerrainBase {
    private float width;
    private float strength;
    private float terrainHeight;
    private int wavelength = 39;
    private SimplexOctave.Disk jitter = new SimplexOctave.Disk();
    private double amplitude = 8.0;

    public TerrainHLDesertMountains(float mountainWidth, float mountainStrength, float height) {
        this.width = mountainWidth;
        this.strength = mountainStrength;
        this.terrainHeight = height;
        this.terrainHeight = 45.0f;
        this.width = 120.0f;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        simplex.riverJitter().evaluateNoise((float)x / (float)this.wavelength, (float)y / (float)this.wavelength, this.jitter);
        float pX = (float)((double)x + this.jitter.deltax() * this.amplitude);
        float pY = (float)((double)y + this.jitter.deltay() * this.amplitude);
        float h = simplex.noise2(pX / 20.0f, pY / 20.0f);
        h = h * h * 1.5f;
        float h2 = simplex.noise2(pX / 14.0f, pY / 14.0f);
        h2 = h2 * h2 * 1.0f;
        h = Math.max(h, h2);
        h += h2;
        float h3 = simplex.noise2(pX / 50.0f, pY / 50.0f);
        h3 = h3 * h3 * 4.0f;
        float m = TerrainHLDesertMountains.unsignedPower(Math.abs(simplex.noise2(pX / this.width, pY / this.width)), 1.3f) * this.strength * river;
        h = m > 10.0f ? h * m / 10.0f : (h += h3);
        m = TerrainHLDesertMountains.above(m, -50.0f);
        float longNoise = simplex.noise2(pX / 100.0f, pY / 100.0f) * 10.0f;
        return this.terrainHeight + h + m + longNoise;
    }
}

