/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.eccentricbiomes;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.BumpyHillsEffect;
import rtg.world.gen.terrain.GroundEffect;
import rtg.world.gen.terrain.HeightEffect;
import rtg.world.gen.terrain.JitterEffect;
import rtg.world.gen.terrain.RaiseEffect;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.VariableRuggednessEffect;

public class TerrainECCBone
extends TerrainBase {
    private float hillockWavelength = 30.0f;
    private float hillockBoost = 5.0f;
    private float hillockVariance = 10.0f;
    private float hillockSpikeWidth = 8.0f;
    private float hillockSpikeHeight = 4.0f;
    private float terrainBase = 68.0f;
    private JitterEffect biomeHeight;

    public TerrainECCBone() {
        BumpyHillsEffect onTop = new BumpyHillsEffect();
        onTop.hillHeight = this.hillockVariance;
        onTop.hillWavelength = this.hillockWavelength;
        onTop.spikeHeight = this.hillockSpikeHeight;
        onTop.spikeWavelength = this.hillockSpikeWidth;
        onTop.hillOctave = 1;
        HeightEffect hillLevel = onTop.plus(new RaiseEffect(this.hillockBoost + this.terrainBase));
        VariableRuggednessEffect hills = new VariableRuggednessEffect();
        hills.ruggedTerrain = hillLevel;
        hills.smoothTerrain = new RaiseEffect(this.terrainBase);
        hills.octave = 1;
        hills.startTransition = 0.1f;
        hills.transitionWidth = 0.35f;
        hills.wavelength = this.hillockWavelength;
        HeightEffect unJittered = hills.plus(new GroundEffect(6.0f));
        this.biomeHeight = new JitterEffect();
        this.biomeHeight.amplitude = 2.0f;
        this.biomeHeight.wavelength = 5.0f;
        this.biomeHeight.jittered = unJittered;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        float result = this.biomeHeight.added(simplex, cell, x, y);
        if (result < 60.0f) {
            throw new RuntimeException();
        }
        return result;
    }
}

