/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.surface.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.util.CellNoise;
import rtg.util.CliffCalculator;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.surface.SurfaceBase;

public class SurfaceVanillaIceMountains
extends SurfaceBase {
    private Block mixBlockTop;
    private byte mixBlockTopMeta;
    private Block mixBlockFill;
    private byte mixBlockFillMeta;
    private Block cliffBlock1;
    private Block cliffBlock2;
    private float width;
    private float height;
    private float smallW;
    private float smallS;

    public SurfaceVanillaIceMountains(BiomeConfig config, Block top, Block filler, Block mixTop, Block mixFill, Block cliff1, Block cliff2, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
        super(config, top, (byte)0, filler, (byte)0);
        this.mixBlockTop = this.getConfigBlock(config, "surfaceMixBlock", mixTop);
        this.mixBlockTopMeta = this.getConfigBlockMeta(config, "surfaceMixBlockMeta", (byte)0);
        this.mixBlockFill = this.getConfigBlock(config, "surfaceMixFillerBlock", mixFill);
        this.mixBlockFillMeta = this.getConfigBlockMeta(config, "surfaceMixFillerBlockMeta", (byte)0);
        this.cliffBlock1 = cliff1;
        this.cliffBlock2 = cliff2;
        this.width = mixWidth;
        this.height = mixHeight;
        this.smallW = smallWidth;
        this.smallS = smallStrength;
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float c = CliffCalculator.calc(x, y, noise);
        boolean cliff = c > 1.4f;
        boolean mix = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            ++depth;
            if (cliff) {
                if (depth > -1 && depth < 2) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? this.cliffBlock2 : this.cliffBlock1;
                    continue;
                }
                if (depth >= 10) continue;
                blocks[(y * 16 + x) * 256 + k] = this.cliffBlock1;
                continue;
            }
            if (depth == 0 && k > 61) {
                if (simplex.noise2((float)i / this.width, (float)j / this.width) + simplex.noise2((float)i / this.smallW, (float)j / this.smallW) * this.smallS > this.height) {
                    blocks[(y * 16 + x) * 256 + k] = this.mixBlockTop;
                    metadata[(y * 16 + x) * 256 + k] = this.mixBlockTopMeta;
                    mix = true;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                metadata[(y * 16 + x) * 256 + k] = this.topBlockMeta;
                continue;
            }
            if (depth >= 4) continue;
            if (mix) {
                blocks[(y * 16 + x) * 256 + k] = this.mixBlockFill;
                metadata[(y * 16 + x) * 256 + k] = this.mixBlockFillMeta;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
            metadata[(y * 16 + x) * 256 + k] = this.fillerBlockMeta;
        }
    }
}

