/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.surface;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.config.rtg.ConfigRTG;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.surface.SurfaceBase;

public class SurfaceRiverOasis
extends SurfaceBase {
    private float cutOffScale = ConfigRTG.riverCutOffScale;
    private float cutOffAmplitude = ConfigRTG.riverCutOffAmplitude;

    public SurfaceRiverOasis(BiomeConfig config) {
        super(config, (Block)Blocks.field_150349_c, (byte)0, Blocks.field_150346_d, (byte)0);
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        Block b;
        int highestY;
        for (highestY = 255; highestY > 0 && (b = blocks[(y * 16 + x) * 256 + highestY]) == Blocks.field_150350_a; --highestY) {
        }
        float amplitude = 0.25f;
        float noiseValue = simplex.octave(0).noise2((float)i / 21.0f, (float)j / 21.0f) * amplitude / 1.0f;
        noiseValue += simplex.octave(1).noise2((float)i / 12.0f, (float)j / 12.0f) * amplitude / 2.0f;
        float noiseNeg = simplex.octave(2).noise2((float)i / this.cutOffScale, (float)j / this.cutOffScale) * this.cutOffAmplitude;
        noiseValue -= noiseNeg;
        if (highestY > 62) {
            noiseValue -= (float)(highestY - 62) * 0.05f;
        }
        if ((double)river > 0.5 && (double)river * 1.1 + (double)noiseValue > 0.79) {
            for (int k = 255; k > -1; --k) {
                b = blocks[(y * 16 + x) * 256 + k];
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b == Blocks.field_150355_j) continue;
                if (++depth == 0 && k > 61) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                    continue;
                }
                if (depth < 4) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                    continue;
                }
                if (depth <= 4) continue;
                return;
            }
        }
    }
}

