/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.feature.tree.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import rtg.config.rtg.ConfigRTG;

public class WorldGenTreesRTG
extends WorldGenTrees {
    private final int minTreeHeight;
    private final boolean vinesGrow;
    private final int metaWood;
    private final int metaLeaves;
    private static final String __OBFID = "CL_00000438";

    public WorldGenTreesRTG() {
        this(false);
    }

    public WorldGenTreesRTG(boolean doBlockNotify) {
        this(doBlockNotify, 4, 0, 0, false);
    }

    public WorldGenTreesRTG(boolean doBlockNotify, int minTreeHeight, int metaWood, int metaLeaves, boolean vinesGrow) {
        super(doBlockNotify);
        this.minTreeHeight = minTreeHeight;
        this.metaWood = metaWood;
        this.metaLeaves = metaLeaves;
        this.vinesGrow = vinesGrow;
    }

    public boolean func_76484_a(World world, Random rand, int worldX, int worldY, int worldZ) {
        int l = rand.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (worldY >= 1 && worldY + l + 1 <= 256) {
            Block block;
            int k1;
            int b0;
            for (int i1 = worldY; i1 <= worldY + 1 + l; ++i1) {
                b0 = 1;
                if (i1 == worldY) {
                    b0 = 0;
                }
                if (i1 >= worldY + 1 + l - 2) {
                    b0 = 2;
                }
                for (int j1 = worldX - b0; j1 <= worldX + b0 && flag; ++j1) {
                    for (k1 = worldZ - b0; k1 <= worldZ + b0 && flag; ++k1) {
                        if (i1 >= 0 && i1 < 256) {
                            block = world.func_147439_a(j1, i1, k1);
                            if (this.isReplaceable(world, j1, i1, k1)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            Block block2 = world.func_147439_a(worldX, worldY - 1, worldZ);
            if (block2 == Blocks.field_150354_m && !ConfigRTG.allowTreesToGenerateOnSand) {
                return false;
            }
            boolean isSoil = block2.canSustainPlant((IBlockAccess)world, worldX, worldY - 1, worldZ, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && worldY < 256 - l - 1) {
                int j2;
                int i2;
                int l1;
                int i3;
                block2.onPlantGrow(world, worldX, worldY - 1, worldZ, worldX, worldY, worldZ);
                b0 = 3;
                int b1 = 0;
                for (k1 = worldY - b0 + l; k1 <= worldY + l; ++k1) {
                    i3 = k1 - (worldY + l);
                    l1 = b1 + 1 - i3 / 2;
                    for (i2 = worldX - l1; i2 <= worldX + l1; ++i2) {
                        j2 = i2 - worldX;
                        for (int k2 = worldZ - l1; k2 <= worldZ + l1; ++k2) {
                            Block block1;
                            int l2 = k2 - worldZ;
                            if (Math.abs(j2) == l1 && Math.abs(l2) == l1 && (rand.nextInt(2) == 0 || i3 == 0) || !(block1 = world.func_147439_a(i2, k1, k2)).isAir((IBlockAccess)world, i2, k1, k2) && !block1.isLeaves((IBlockAccess)world, i2, k1, k2)) continue;
                            this.func_150516_a(world, i2, k1, k2, (Block)Blocks.field_150362_t, this.metaLeaves);
                        }
                    }
                }
                for (k1 = 0; k1 < l; ++k1) {
                    block = world.func_147439_a(worldX, worldY + k1, worldZ);
                    if (!block.isAir((IBlockAccess)world, worldX, worldY + k1, worldZ) && !block.isLeaves((IBlockAccess)world, worldX, worldY + k1, worldZ)) continue;
                    this.func_150516_a(world, worldX, worldY + k1, worldZ, Blocks.field_150364_r, this.metaWood);
                    if (!this.vinesGrow || k1 <= 0) continue;
                    if (rand.nextInt(3) > 0 && world.func_147437_c(worldX - 1, worldY + k1, worldZ)) {
                        this.func_150516_a(world, worldX - 1, worldY + k1, worldZ, Blocks.field_150395_bd, 8);
                    }
                    if (rand.nextInt(3) > 0 && world.func_147437_c(worldX + 1, worldY + k1, worldZ)) {
                        this.func_150516_a(world, worldX + 1, worldY + k1, worldZ, Blocks.field_150395_bd, 2);
                    }
                    if (rand.nextInt(3) > 0 && world.func_147437_c(worldX, worldY + k1, worldZ - 1)) {
                        this.func_150516_a(world, worldX, worldY + k1, worldZ - 1, Blocks.field_150395_bd, 1);
                    }
                    if (rand.nextInt(3) <= 0 || !world.func_147437_c(worldX, worldY + k1, worldZ + 1)) continue;
                    this.func_150516_a(world, worldX, worldY + k1, worldZ + 1, Blocks.field_150395_bd, 4);
                }
                if (this.vinesGrow) {
                    for (k1 = worldY - 3 + l; k1 <= worldY + l; ++k1) {
                        i3 = k1 - (worldY + l);
                        l1 = 2 - i3 / 2;
                        for (i2 = worldX - l1; i2 <= worldX + l1; ++i2) {
                            for (j2 = worldZ - l1; j2 <= worldZ + l1; ++j2) {
                                if (!world.func_147439_a(i2, k1, j2).isLeaves((IBlockAccess)world, i2, k1, j2)) continue;
                                if (rand.nextInt(4) == 0 && world.func_147439_a(i2 - 1, k1, j2).isAir((IBlockAccess)world, i2 - 1, k1, j2)) {
                                    this.growVines(world, i2 - 1, k1, j2, 8);
                                }
                                if (rand.nextInt(4) == 0 && world.func_147439_a(i2 + 1, k1, j2).isAir((IBlockAccess)world, i2 + 1, k1, j2)) {
                                    this.growVines(world, i2 + 1, k1, j2, 2);
                                }
                                if (rand.nextInt(4) == 0 && world.func_147439_a(i2, k1, j2 - 1).isAir((IBlockAccess)world, i2, k1, j2 - 1)) {
                                    this.growVines(world, i2, k1, j2 - 1, 1);
                                }
                                if (rand.nextInt(4) != 0 || !world.func_147439_a(i2, k1, j2 + 1).isAir((IBlockAccess)world, i2, k1, j2 + 1)) continue;
                                this.growVines(world, i2, k1, j2 + 1, 4);
                            }
                        }
                    }
                    if (rand.nextInt(5) == 0 && l > 5) {
                        for (k1 = 0; k1 < 2; ++k1) {
                            for (i3 = 0; i3 < 4; ++i3) {
                                if (rand.nextInt(4 - k1) != 0) continue;
                                l1 = rand.nextInt(3);
                                this.func_150516_a(world, worldX + Direction.field_71583_a[Direction.field_71580_e[i3]], worldY + l - 5 + k1, worldZ + Direction.field_71581_b[Direction.field_71580_e[i3]], Blocks.field_150375_by, l1 << 2 | i3);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void growVines(World world, int worldX, int worldY, int worldZ, int vineLength) {
        this.func_150516_a(world, worldX, worldY, worldZ, Blocks.field_150395_bd, vineLength);
        int i1 = 4;
        while (world.func_147439_a(worldX, --worldY, worldZ).isAir((IBlockAccess)world, worldX, worldY, worldZ) && i1 > 0) {
            this.func_150516_a(world, worldX, worldY, worldZ, Blocks.field_150395_bd, vineLength);
            --i1;
        }
        return;
    }
}

