/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.feature.tree.rtg;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import rtg.config.rtg.ConfigRTG;
import rtg.world.gen.feature.tree.rtg.TreeRTG;

public class TreeRTGCeibaRosea
extends TreeRTG {
    protected float length = 16.0f;
    protected int branch = 5;
    protected float verStart = 0.32f;
    protected float verRand = 0.1f;

    public TreeRTGCeibaRosea() {
    }

    public TreeRTGCeibaRosea(float length, int branch, float verStart, float verRand) {
        this();
        this.length = length;
        this.branch = branch;
        this.verStart = verStart;
        this.verRand = verRand;
    }

    @Override
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        if (b == Blocks.field_150354_m && !ConfigRTG.allowTreesToGenerateOnSand) {
            return false;
        }
        if (b != Blocks.field_150349_c && b != Blocks.field_150346_d && b != Blocks.field_150354_m) {
            return false;
        }
        this.trunkLogMeta = this.getTrunkLogMeta(this.logMeta);
        float r = rand.nextFloat() * 360.0f;
        if (this.trunkSize > 0) {
            for (int k = 0; k < 5; ++k) {
                this.generateBranch(world, rand, (float)x + 0.5f, y + this.trunkSize, (float)z + 0.5f, (float)(120 * k - 25 + rand.nextInt(50)) + r, 1.6f + rand.nextFloat() * 0.1f, (float)this.trunkSize * 1.8f, 1.0f, true);
            }
        }
        for (int i = y + this.trunkSize - 2; i < y + this.crownSize + 2; ++i) {
            this.placeLogBlock(world, x, i, z, this.logBlock, this.logMeta, this.generateFlag);
            this.placeLogBlock(world, x + 1, i, z + 1, this.logBlock, this.logMeta, this.generateFlag);
        }
        for (int j = 0; j < this.branch; ++j) {
            float horDir = 80 * j - 40 + rand.nextInt(80);
            float verDir = this.verStart + rand.nextFloat() * this.verRand;
            this.generateBranch(world, rand, (float)x + 0.5f, y + this.crownSize, (float)z + 0.5f, horDir, verDir, this.length, 1.0f, false);
            int eX = (int)(Math.cos((double)horDir * Math.PI / 180.0) * (double)verDir * (double)this.length);
            int eZ = (int)(Math.sin((double)horDir * Math.PI / 180.0) * (double)verDir * (double)this.length);
            int eY = (int)((1.0f - verDir) * this.length);
            for (int m = 0; m < 2; ++m) {
                this.generateLeaves(world, rand, x + eX - 2 + rand.nextInt(5), y + this.crownSize + eY + rand.nextInt(2), z + eZ - 2 + rand.nextInt(5), 4.0f, 1.5f);
            }
            eX = (int)((float)eX * 0.8f);
            eY = (int)((float)eY * 0.8f);
            eZ = (int)((float)eZ * 0.8f);
            this.generateLeaves(world, rand, x + eX, y + this.crownSize + eY, z + eZ, 3.0f, 1.5f);
        }
        return true;
    }

    public void generateBranch(World world, Random rand, float x, float y, float z, double horDir, float verDir, float length, float speed, boolean isTrunk) {
        if (verDir < 0.0f) {
            verDir = -verDir;
        }
        float c = 0.0f;
        float velY = 1.0f - verDir;
        if (verDir > 1.0f) {
            verDir = 1.0f - (verDir - 1.0f);
        }
        float velX = (float)Math.cos(horDir * Math.PI / 180.0) * verDir;
        float velZ = (float)Math.sin(horDir * Math.PI / 180.0) * verDir;
        while (c < length) {
            if (isTrunk) {
                this.placeLogBlock(world, (int)x, (int)y, (int)z, this.logBlock, (byte)this.trunkLogMeta, this.generateFlag);
            } else {
                this.placeLogBlock(world, (int)x, (int)y, (int)z, this.logBlock, this.logMeta, this.generateFlag);
            }
            x += velX;
            y += velY;
            z += velZ;
            c += speed;
        }
    }

    public void generateLeaves(World world, Random rand, float x, float y, float z, float size, float width) {
        int s = (int)(size - 1.0f);
        int w = (int)((size - 1.0f) * width);
        for (int i = -w; i <= w; ++i) {
            for (int j = -s + 1; j <= s; ++j) {
                for (int k = -w; k <= w; ++k) {
                    float dist = Math.abs((float)i / width) + (float)Math.abs(j) + Math.abs((float)k / width);
                    if (!(dist <= size - 0.5f) && (!(dist <= size) || !rand.nextBoolean())) continue;
                    if (dist < 1.3f) {
                        this.placeLogBlock(world, (int)x + i, (int)y + j, (int)z + k, this.logBlock, this.logMeta, this.generateFlag);
                    }
                    if (this.noLeaves || !world.func_147437_c((int)x + i, (int)y + j, (int)z + k)) continue;
                    this.placeLeavesBlock(world, (int)x + i, (int)y + j, (int)z + k, this.leavesBlock, this.leavesMeta, this.generateFlag);
                }
            }
        }
    }

    public TreeRTGCeibaRosea setLength(float length) {
        this.length = length;
        return this;
    }

    public TreeRTGCeibaRosea setBranch(int branch) {
        this.branch = branch;
        return this;
    }

    public TreeRTGCeibaRosea setVerStart(float verStart) {
        this.verStart = verStart;
        return this;
    }

    public TreeRTGCeibaRosea setVerRand(float verRand) {
        this.verRand = verRand;
        return this;
    }
}

