/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.feature.tree.rtg;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import rtg.world.gen.feature.tree.rtg.TreeRTG;

public class TreeRTGCeibaPentandra
extends TreeRTG {
    protected float length = 13.0f;
    protected int branch = 3;
    protected float verStart = 0.32f;
    protected float verRand = 0.1f;

    public TreeRTGCeibaPentandra() {
    }

    public TreeRTGCeibaPentandra(float length, int branch, float verStart, float verRand) {
        this();
        this.length = length;
        this.branch = branch;
        this.verStart = verStart;
        this.verRand = verRand;
    }

    @Override
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        if (b != Blocks.field_150349_c && b != Blocks.field_150346_d) {
            return false;
        }
        this.trunkLogMeta = this.getTrunkLogMeta(this.logMeta);
        if (this.trunkSize > 0) {
            for (int k = 0; k < 3; ++k) {
                this.generateBranch(world, rand, x, y + this.trunkSize, z, 120 * k - 40 + rand.nextInt(80), 1.6f + rand.nextFloat() * 0.1f, (float)this.trunkSize * 1.7f, 1.0f, true);
            }
        }
        for (int i = y + this.trunkSize; i < y + this.crownSize; ++i) {
            this.placeLogBlock(world, x, i, z, this.logBlock, this.logMeta, this.generateFlag);
        }
        for (int j = 0; j < this.branch; ++j) {
            float horDir = 120 * j - 60 + rand.nextInt(120);
            float verDir = this.verStart + rand.nextFloat() * this.verRand;
            this.generateBranch(world, rand, x, y + this.crownSize, z, horDir, verDir, this.length, 1.0f, false);
            int eX = x + (int)(Math.cos((double)horDir * Math.PI / 180.0) * (double)verDir * (double)this.length);
            int eZ = z + (int)(Math.sin((double)horDir * Math.PI / 180.0) * (double)verDir * (double)this.length);
            int eY = y + this.crownSize + (int)((1.0f - verDir) * this.length);
            for (int m = 0; m < 1; ++m) {
                this.generateLeaves(world, rand, eX, eY, eZ, 4.0f, 1.5f);
            }
        }
        return true;
    }

    public void generateBranch(World world, Random rand, float x, float y, float z, double horDir, float verDir, float length, float speed, boolean isTrunk) {
        if (verDir < 0.0f) {
            verDir = -verDir;
        }
        float c = 0.0f;
        float velY = 1.0f - verDir;
        if (verDir > 1.0f) {
            verDir = 1.0f - (verDir - 1.0f);
        }
        float velX = (float)Math.cos(horDir * Math.PI / 180.0) * verDir;
        float velZ = (float)Math.sin(horDir * Math.PI / 180.0) * verDir;
        while (c < length) {
            if (isTrunk) {
                this.placeLogBlock(world, (int)x, (int)y, (int)z, this.logBlock, (byte)this.trunkLogMeta, this.generateFlag);
            } else {
                this.placeLogBlock(world, (int)x, (int)y, (int)z, this.logBlock, this.logMeta, this.generateFlag);
            }
            x += velX;
            y += velY;
            z += velZ;
            c += speed;
        }
    }

    public void generateLeaves(World world, Random rand, int x, int y, int z, float size, float width) {
        int s = (int)(size - 1.0f);
        int w = (int)((size - 1.0f) * width);
        for (int i = -w; i <= w; ++i) {
            for (int j = -s; j <= s; ++j) {
                for (int k = -w; k <= w; ++k) {
                    float dist = Math.abs((float)i / width) + (float)Math.abs(j) + Math.abs((float)k / width);
                    if (!(dist <= size - 0.5f) && (!(dist <= size) || !rand.nextBoolean())) continue;
                    if (dist < 0.6f) {
                        this.placeLogBlock(world, x + i, y + j, z + k, this.logBlock, this.logMeta, this.generateFlag);
                    }
                    if (this.noLeaves || !world.func_147437_c(x + i, y + j, z + k)) continue;
                    this.placeLeavesBlock(world, x + i, y + j, z + k, this.leavesBlock, this.leavesMeta, this.generateFlag);
                }
            }
        }
    }

    public TreeRTGCeibaPentandra setLength(float length) {
        this.length = length;
        return this;
    }

    public TreeRTGCeibaPentandra setBranch(int branch) {
        this.branch = branch;
        return this;
    }

    public TreeRTGCeibaPentandra setVerStart(float verStart) {
        this.verStart = verStart;
        return this;
    }

    public TreeRTGCeibaPentandra setVerRand(float verRand) {
        this.verRand = verRand;
        return this;
    }
}

