/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.feature.tree.rtg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import rtg.config.rtg.ConfigRTG;
import rtg.util.WorldUtil;

public class TreeRTG
extends WorldGenAbstractTree {
    public Block logBlock;
    public byte logMeta;
    public Block leavesBlock;
    public byte leavesMeta;
    public int trunkSize;
    public int crownSize;
    public boolean noLeaves;
    public Block saplingBlock;
    public byte saplingMeta;
    public int generateFlag;
    public int minTrunkSize;
    public int maxTrunkSize;
    public int minCrownSize;
    public int maxCrownSize;
    public ArrayList<Block> validGroundBlocks;
    protected int trunkLogMeta;
    private boolean allowBarkCoveredLogs;

    public TreeRTG(boolean notify) {
        super(notify);
    }

    public TreeRTG() {
        this(false);
        this.logBlock = Blocks.field_150364_r;
        this.logMeta = 0;
        this.leavesBlock = Blocks.field_150362_t;
        this.leavesMeta = 0;
        this.trunkSize = 2;
        this.crownSize = 4;
        this.noLeaves = false;
        this.saplingBlock = Blocks.field_150345_g;
        this.saplingMeta = 0;
        this.generateFlag = 2;
        this.minTrunkSize = 0;
        this.maxTrunkSize = 0;
        this.minCrownSize = 0;
        this.maxCrownSize = 0;
        this.validGroundBlocks = new ArrayList<Block>(Arrays.asList(Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m));
        this.allowBarkCoveredLogs = ConfigRTG.allowBarkCoveredLogs;
        this.trunkLogMeta = this.logMeta;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        return false;
    }

    public void buildTrunk(World world, Random rand, int x, int y, int z) {
    }

    public void buildBranch(World world, Random rand, int x, int y, int z, int dX, int dZ, int logLength, int leaveSize) {
    }

    public void buildLeaves(World world, int x, int y, int z) {
        if (this.noLeaves) {
            return;
        }
    }

    public void buildLeaves(World world, Random rand, int x, int y, int z, int size) {
    }

    public TreeRTG setLogBlock(Block logBlock) {
        this.logBlock = logBlock;
        return this;
    }

    public TreeRTG setLogMeta(byte logMeta) {
        this.logMeta = logMeta;
        return this;
    }

    public TreeRTG setLeavesBlock(Block leavesBlock) {
        this.leavesBlock = leavesBlock;
        return this;
    }

    public TreeRTG setLeavesMeta(byte leavesMeta) {
        this.leavesMeta = leavesMeta;
        return this;
    }

    public TreeRTG setTrunkSize(int trunkSize) {
        this.trunkSize = trunkSize;
        return this;
    }

    public TreeRTG setCrownSize(int crownSize) {
        this.crownSize = crownSize;
        return this;
    }

    public TreeRTG setNoLeaves(boolean noLeaves) {
        this.noLeaves = noLeaves;
        return this;
    }

    protected boolean isGroundValid(World world, int x, int y, int z) {
        return this.isGroundValid(world, x, y, z, ConfigRTG.allowTreesToGenerateOnSand);
    }

    protected boolean isGroundValid(World world, int x, int y, int z, boolean sandAllowed) {
        Block g = world.func_147439_a(x, y - 1, z);
        if (g == Blocks.field_150354_m && !sandAllowed) {
            return false;
        }
        for (int i = 0; i < this.validGroundBlocks.size(); ++i) {
            if (g != this.validGroundBlocks.get(i)) continue;
            return true;
        }
        return false;
    }

    protected boolean isGroundValid(World world, ArrayList<Integer> x, ArrayList<Integer> y, ArrayList<Integer> z) {
        if (x.isEmpty() || y.isEmpty() || z.isEmpty()) {
            throw new RuntimeException("Unable to determine if ground is valid. No trunks.");
        }
        for (int i = 0; i < x.size(); ++i) {
            if (this.isGroundValid(world, x.get(i), y.get(i), z.get(i))) continue;
            return false;
        }
        return true;
    }

    protected void placeLogBlock(World world, int x, int y, int z, Block logBlock, byte logMeta, int generateFlag) {
        if (this.isReplaceable(world, x, y, z)) {
            world.func_147465_d(x, y, z, logBlock, (int)logMeta, generateFlag);
        }
    }

    protected void placeLeavesBlock(World world, int x, int y, int z, Block leavesBlock, byte leavesMeta, int generateFlag) {
        if (world.func_147437_c(x, y, z)) {
            world.func_147465_d(x, y, z, leavesBlock, (int)leavesMeta, generateFlag);
        }
    }

    public boolean isReplaceable(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        return b.isAir((IBlockAccess)world, x, y, z) || b.isLeaves((IBlockAccess)world, x, y, z) || b.isWood((IBlockAccess)world, x, y, z) || this.canGrowInto(b);
    }

    protected boolean func_150523_a(Block blockType) {
        return this.canGrowInto(blockType);
    }

    protected boolean canGrowInto(Block blockType) {
        Material material = blockType.func_149688_o();
        return material == Material.field_151579_a || material == Material.field_151584_j || material == Material.field_151585_k || material == Material.field_151577_b || material == Material.field_151578_c || material == Material.field_151575_d || material == Material.field_151582_l || material == Material.field_151586_h || material == Material.field_151597_y;
    }

    public boolean hasSpaceToGrow(World world, Random rand, int x, int y, int z, int treeHeight) {
        WorldUtil worldUtil = new WorldUtil(world);
        return worldUtil.isSurroundedByBlock(Blocks.field_150350_a, treeHeight, WorldUtil.SurroundCheckType.UP, rand, x, y, z);
    }

    public int getTrunkLogMeta(int defaultMeta) {
        if (!this.allowBarkCoveredLogs) {
            return defaultMeta;
        }
        return defaultMeta + 12;
    }

    public int getTrunkLogMeta(byte defaultMeta) {
        return this.getTrunkLogMeta((int)defaultMeta);
    }
}

