/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.highlands;

import highlands.api.HighlandsBiomes;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.api.biome.BiomeConfig;
import rtg.world.biome.deco.DecoFallenTree;
import rtg.world.biome.deco.DecoTree;
import rtg.world.biome.realistic.highlands.RealisticBiomeHLBase;
import rtg.world.gen.feature.tree.highlands.HLPalmTreeRTG;
import rtg.world.gen.feature.tree.rtg.TreeRTGCocosNucifera;
import rtg.world.gen.surface.highlands.SurfaceHLDesertIsland;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.highlands.TerrainHLDesertIsland;

public class RealisticBiomeHLDesertIsland
extends RealisticBiomeHLBase {
    public static BiomeGenBase hlBiome = HighlandsBiomes.desertIsland;
    public static Block topBlock = RealisticBiomeHLDesertIsland.hlBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeHLDesertIsland.hlBiome.field_76753_B;

    public RealisticBiomeHLDesertIsland(BiomeConfig config) {
        super(config, hlBiome, BiomeGenBase.field_76781_i, (TerrainBase)new TerrainHLDesertIsland(90.0f, 180.0f, 13.0f, 100.0f, 38.0f, 260.0f, 71.0f), new SurfaceHLDesertIsland(config, topBlock, fillerBlock));
        this.disallowStoneBeaches = true;
        this.waterSurfaceLakeChance = 0;
        DecoTree highlandsPalmTrees = new DecoTree((WorldGenerator)new HLPalmTreeRTG(8, 7, false));
        highlandsPalmTrees.treeType = DecoTree.TreeType.WORLDGEN;
        highlandsPalmTrees.treeCondition = DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        highlandsPalmTrees.distribution = new DecoTree.Distribution(100.0f, 6.0f, 0.8f);
        highlandsPalmTrees.treeConditionNoise = 0.0f;
        highlandsPalmTrees.treeConditionChance = 4;
        highlandsPalmTrees.maxY = 75;
        this.addDeco(highlandsPalmTrees);
        TreeRTGCocosNucifera nuciferaTree = new TreeRTGCocosNucifera();
        nuciferaTree.logBlock = Blocks.field_150364_r;
        nuciferaTree.logMeta = (byte)3;
        nuciferaTree.leavesBlock = Blocks.field_150362_t;
        nuciferaTree.leavesMeta = (byte)3;
        nuciferaTree.minTrunkSize = 7;
        nuciferaTree.maxTrunkSize = 8;
        nuciferaTree.minCrownSize = 8;
        nuciferaTree.maxCrownSize = 12;
        nuciferaTree.noLeaves = false;
        this.addTree(nuciferaTree);
        DecoTree vanillaPalmTrees = new DecoTree(nuciferaTree);
        vanillaPalmTrees.treeType = DecoTree.TreeType.RTG_TREE;
        vanillaPalmTrees.treeCondition = DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        vanillaPalmTrees.distribution = new DecoTree.Distribution(80.0f, 60.0f, -15.0f);
        vanillaPalmTrees.treeConditionNoise = 0.0f;
        vanillaPalmTrees.treeConditionChance = 8;
        vanillaPalmTrees.maxY = 75;
        this.addDeco(vanillaPalmTrees);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.loops = 1;
        decoFallenTree.distribution = new DecoFallenTree.Distribution(80.0f, 60.0f, -15.0f);
        decoFallenTree.logCondition = DecoFallenTree.LogCondition.NOISE_LESS_AND_RANDOM_CHANCE;
        decoFallenTree.logConditionNoise = 0.0f;
        decoFallenTree.logConditionChance = 24;
        decoFallenTree.maxY = 70;
        decoFallenTree.logBlock = Blocks.field_150364_r;
        decoFallenTree.logMeta = (byte)3;
        decoFallenTree.leavesBlock = Blocks.field_150362_t;
        decoFallenTree.leavesMeta = (byte)-1;
        decoFallenTree.minSize = 4;
        decoFallenTree.maxSize = 6;
        this.addDeco(decoFallenTree, this.config._boolean("decorationLogs"));
        this.noLakes = true;
        this.noWaterFeatures = true;
    }
}

