/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco.helper;

import java.util.Random;
import net.minecraft.world.World;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;

public class DecoHelperBorder
extends DecoBase {
    private DecoBase adjusted;
    private float allAbove;
    private float noneBelow;

    public DecoHelperBorder(DecoBase toAdjust, float allAbove, float noneBelow) {
        if (allAbove < noneBelow) {
            throw new RuntimeException("Above and below parameters swapped");
        }
        this.adjusted = toAdjust;
        this.allAbove = allAbove;
        this.noneBelow = noneBelow;
        if (!toAdjust.properlyDefined()) {
            throw new RuntimeException();
        }
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river, boolean hasPlacedVillageBlocks) {
        if (strength < this.noneBelow) {
            return;
        }
        if (strength >= this.allAbove) {
            this.adjusted.generate(biome, world, rand, chunkX, chunkY, simplex, cell, strength, river, hasPlacedVillageBlocks);
        } else {
            float adjustedStrength = (strength - this.noneBelow) / (this.allAbove - this.noneBelow);
            this.adjusted.generate(biome, world, rand, chunkX, chunkY, simplex, cell, adjustedStrength, river, hasPlacedVillageBlocks);
        }
    }
}

