/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.feature.WorldGenGrass;

public class DecoLargeFernDoubleTallgrass
extends DecoBase {
    private final int GRASS_META = 2;
    private final int FERN_META = 3;
    public float strengthFactor = 0.0f;
    public int maxY = 255;
    public int loops = 1;
    public int grassChance = 0;
    public int fernChance = 0;

    public DecoLargeFernDoubleTallgrass() {
        this.addDecoTypes(DecoBase.DecoType.GRASS_DOUBLE, DecoBase.DecoType.FERN_DOUBLE);
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river, boolean hasPlacedVillageBlocks) {
        if (this.allowed && TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            WorldGenGrass worldgeneratorDoubleTallgrass = new WorldGenGrass((Block)Blocks.field_150398_cm, 2);
            WorldGenGrass worldgeneratorLargeFern = new WorldGenGrass((Block)Blocks.field_150398_cm, 3);
            this.loops = this.strengthFactor > 0.0f ? (int)(this.strengthFactor * strength) : this.loops;
            for (int i = 0; i < this.loops; ++i) {
                int intX = chunkX + rand.nextInt(16) + 8;
                int intY = rand.nextInt(this.maxY);
                int intZ = chunkY + rand.nextInt(16) + 8;
                if (intY > this.maxY) continue;
                if (this.fernChance > 0) {
                    if (rand.nextInt(this.fernChance) == 0) {
                        worldgeneratorLargeFern.func_76484_a(world, rand, intX, intY, intZ);
                        continue;
                    }
                    worldgeneratorDoubleTallgrass.func_76484_a(world, rand, intX, intY, intZ);
                    continue;
                }
                if (this.grassChance > 0) {
                    if (rand.nextInt(this.grassChance) == 0) {
                        worldgeneratorDoubleTallgrass.func_76484_a(world, rand, intX, intY, intZ);
                        continue;
                    }
                    worldgeneratorLargeFern.func_76484_a(world, rand, intX, intY, intZ);
                    continue;
                }
                if (rand.nextBoolean()) {
                    worldgeneratorDoubleTallgrass.func_76484_a(world, rand, intX, intY, intZ);
                    continue;
                }
                worldgeneratorLargeFern.func_76484_a(world, rand, intX, intY, intZ);
            }
        }
    }
}

