/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.deco.DecoTree;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.feature.tree.abyssalcraft.WorldGenTreeACDarkwood;

public class DecoAbyssalCraftTree
extends DecoTree {
    public TreeType treeType;

    public DecoAbyssalCraftTree() {
        this.loops = 1;
        this.strengthFactorForLoops = 0.0f;
        this.strengthNoiseFactorForLoops = false;
        this.strengthNoiseFactorXForLoops = false;
        this.treeType = TreeType.DARKWOOD;
        this.distribution = new DecoTree.Distribution(100.0f, 5.0f, 0.8f);
        this.treeCondition = DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE;
        this.treeConditionNoise = 0.0f;
        this.treeConditionChance = 1;
        this.minY = 1;
        this.maxY = 255;
        this.logBlock = Blocks.field_150364_r;
        this.logMeta = 0;
        this.leavesBlock = Blocks.field_150362_t;
        this.leavesMeta = (byte)-1;
        this.minSize = 2;
        this.maxSize = 4;
        this.addDecoTypes(DecoBase.DecoType.TREE);
    }

    @Override
    public boolean properlyDefined() {
        return true;
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river, boolean hasPlacedVillageBlocks) {
        if (this.allowed && TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            float noise = simplex.noise2((float)chunkX / this.distribution.noiseDivisor, (float)chunkY / this.distribution.noiseDivisor) * this.distribution.noiseFactor + this.distribution.noiseAddend;
            int loopCount = this.loops;
            loopCount = this.strengthFactorForLoops > 0.0f ? (int)(this.strengthFactorForLoops * strength) : loopCount;
            loopCount = this.strengthNoiseFactorForLoops ? (int)(noise * strength) : loopCount;
            loopCount = this.strengthNoiseFactorXForLoops ? (int)(noise * this.strengthFactorForLoops * strength) : loopCount;
            block3: for (int i = 0; i < loopCount; ++i) {
                int intX = chunkX + rand.nextInt(16) + 8;
                int intZ = chunkY + rand.nextInt(16) + 8;
                int intY = world.func_72976_f(intX, intZ);
                switch (this.treeType) {
                    case DARKWOOD: {
                        if (intY > this.maxY || intY < this.minY || !this.isValidTreeCondition(noise, rand, strength)) continue block3;
                        WorldGenTreeACDarkwood worldgenerator = new WorldGenTreeACDarkwood(6 + rand.nextInt(6), 10 + rand.nextInt(10), 0, 0);
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, intX, intY, intZ);
                        continue block3;
                    }
                }
            }
        }
    }

    public static enum TreeType {
        DARKWOOD;

    }
}

