/*
 * Decompiled with CFR 0.152.
 */
package rtg.world;

import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import rtg.RTG;
import rtg.world.biome.WorldChunkManagerRTG;
import rtg.world.gen.ChunkProviderRTG;

public class WorldTypeRTG
extends WorldType {
    private static WorldChunkManagerRTG chunkManager;
    public static ChunkProviderRTG chunkProvider;

    private static Runnable clearChunkManager() {
        return new Runnable(){

            @Override
            public void run() {
                chunkManager = null;
            }
        };
    }

    private static Runnable clearChunkProvider() {
        return new Runnable(){

            @Override
            public void run() {
                chunkProvider = null;
            }
        };
    }

    public WorldTypeRTG(String name) {
        super(name);
    }

    public WorldChunkManager getChunkManager(World world) {
        if (world.field_73011_w.field_76574_g == 0) {
            if (chunkManager == null) {
                chunkManager = new WorldChunkManagerRTG(world, this);
                RTG.instance.runOnNextServerCloseOnly(WorldTypeRTG.clearChunkManager());
            }
            return chunkManager;
        }
        return new WorldChunkManager(world);
    }

    public IChunkProvider getChunkGenerator(World world, String generatorOptions) {
        if (world.field_73011_w.field_76574_g == 0) {
            if (chunkProvider == null) {
                chunkProvider = new ChunkProviderRTG(world, world.func_72905_C());
                RTG.instance.runOnNextServerCloseOnly(WorldTypeRTG.clearChunkProvider());
                RTG.eventMgr.setDimensionChunkLoadEvent(world.field_73011_w.field_76574_g, WorldTypeRTG.chunkProvider.delayedDecorator);
                RTG.instance.runOnNextServerCloseOnly(chunkProvider.clearOnServerClose());
                return chunkProvider;
            }
            ChunkProviderRTG result = new ChunkProviderRTG(world, world.func_72905_C());
            result.isFakeGenerator();
            return result;
        }
        return new ChunkProviderGenerate(world, world.func_72905_C(), world.func_72912_H().func_76089_r());
    }

    public float getCloudHeight() {
        return 256.0f;
    }
}

