/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import rtg.util.Converter;

public class WeakHashCache<Key, Value> {
    private final Converter<Value, Key> keyer;
    private WeakHashMap<Value, Key> storageIndicator = new WeakHashMap();
    private WeakHashMap<Key, WeakReference<Value>> mapping = new WeakHashMap();

    public WeakHashCache(Converter<Value, Key> keyer) {
        this.keyer = keyer;
    }

    public int size() {
        return this.storageIndicator.size();
    }

    public void cache(Value value) {
        Key key = this.keyer.of(value);
        this.storageIndicator.put(value, key);
        this.mapping.put(key, new WeakReference<Value>(value));
    }

    public Value get(Key key) throws ValueMissing {
        Object result;
        WeakReference<Value> reference = this.mapping.get(key);
        if (reference != null && (result = reference.get()) != null) {
            return (Value)result;
        }
        throw new ValueMissing();
    }

    public static class ValueMissing
    extends Exception {
    }
}

