/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TimedHashMap<Key, Value>
implements Map<Key, Value> {
    private final int holdMillis;
    private Map<Key, Value> map = new HashMap<Key, Value>();
    private LinkTail link = new LinkTail();

    public TimedHashMap(int holdTicks) {
        this.holdMillis = holdTicks;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object arg0) {
        this.clearEntries();
        return this.map.containsKey(arg0);
    }

    @Override
    public boolean containsValue(Object arg0) {
        this.clearEntries();
        return this.map.containsValue(arg0);
    }

    @Override
    public Value get(Object arg0) {
        this.clearEntries();
        return this.map.get(arg0);
    }

    @Override
    public Value put(Key arg0, Value arg1) {
        this.clearEntries();
        if (this.map.containsKey(arg0)) {
            return this.map.put(arg0, arg1);
        }
        this.link.add(arg0);
        return this.map.put(arg0, arg1);
    }

    @Override
    public Value remove(Object arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Key> keySet() {
        this.clearEntries();
        return this.map.keySet();
    }

    @Override
    public Collection<Value> values() {
        this.clearEntries();
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        this.clearEntries();
        return this.map.entrySet();
    }

    private synchronized void clearEntries() {
        this.link.clear();
    }

    class Timed<Key>
    extends LinkEntry {
        final long time;
        final Key timed;

        Timed(Key timed) {
            this.timed = timed;
            this.time = System.currentTimeMillis();
        }

        @Override
        void remove() {
            TimedHashMap.this.map.remove(this.timed);
        }

        @Override
        boolean old() {
            return this.time + (long)TimedHashMap.this.holdMillis < System.currentTimeMillis();
        }
    }

    class LinkTail
    extends LinkEntry {
        LinkEntry latest;

        LinkTail() {
            this.latest = this;
            this.next = this;
        }

        @Override
        boolean old() {
            return false;
        }

        @Override
        void remove() {
            throw new RuntimeException();
        }

        void clear() {
            while (this.next.old()) {
                this.next.remove();
                this.next = this.next.next;
            }
        }

        void add(Key added) {
            Timed toAdd = new Timed(added);
            toAdd.next = this;
            this.latest.next = toAdd;
            this.latest = toAdd;
        }
    }

    abstract class LinkEntry {
        LinkEntry next;

        LinkEntry() {
        }

        abstract boolean old();

        abstract void remove();
    }
}

