/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

public class SimplexOctave {
    private static final double STRETCH_2D = -0.211324865405187;
    private static final double SQUISH_2D = 0.366025403784439;
    private static final double STRETCH_3D = -0.16666666666666666;
    private static final double SQUISH_3D = 0.3333333333333333;
    private static final long DEFAULT_SEED = 0L;
    private int[] perm = new int[1024];
    private int[] perm2D = new int[1024];
    private int[] perm2D_sph2 = new int[1024];
    private int[] perm3D = new int[1024];
    private static final LatticePoint2D[] LOOKUP_2D;
    private static Contribution3[] LOOKUP_3D;
    private static double[] GRADIENTS_2D;
    private static final double[] GRADIENTS_SPH2;
    private static double[] GRADIENTS_3D;

    public SimplexOctave() {
        this(0L);
    }

    public SimplexOctave(long seed) {
        int i;
        int[] source = new int[1024];
        for (i = 0; i < 1024; ++i) {
            source[i] = i;
        }
        for (i = 1023; i >= 0; --i) {
            int r = (int)(((seed = seed * 6364136223846793005L + 1442695040888963407L) + 31L) % (long)(i + 1));
            if (r < 0) {
                r += i + 1;
            }
            this.perm[i] = source[r];
            this.perm2D[i] = this.perm[i] % 12 * 2;
            this.perm2D_sph2[i] = this.perm[i] / 12 % 12 * 2;
            this.perm3D[i] = this.perm[i] % 48 * 3;
            source[r] = source[i];
        }
    }

    public float noise1(float x) {
        return (float)this.noise(x, 0.5);
    }

    public float noise2(float x, float y) {
        return (float)this.noise(x, y);
    }

    public float noise3(float x, float y, float z) {
        return (float)this.noise(x, y, z);
    }

    public double improvedNoise(double x, double y, double z) {
        return this.noise(x, y, z);
    }

    public double noise(double x, double y) {
        double value = 0.0;
        double s = -0.211324865405187 * (x + y);
        double xs = x + s;
        double ys = y + s;
        int xsb = SimplexOctave.fastFloor(xs);
        int ysb = SimplexOctave.fastFloor(ys);
        double xsi = xs - (double)xsb;
        double ysi = ys - (double)ysb;
        int a = (int)(ysi - xsi + 1.0);
        int index = a << 2 | (int)(xsi + ysi / 2.0 + (double)a / 2.0) << 3 | (int)(ysi + xsi / 2.0 + 0.5 - (double)a / 2.0) << 4;
        double ssi = (xsi + ysi) * 0.366025403784439;
        double xi = xsi + ssi;
        double yi = ysi + ssi;
        for (int i = 0; i < 4; ++i) {
            LatticePoint2D c = LOOKUP_2D[index + i];
            double dx = xi + c.dx;
            double dy = yi + c.dy;
            double attn = 2.0 - dx * dx - dy * dy;
            if (attn <= 0.0) continue;
            int pxm = xsb + c.xsv & 0x3FF;
            int pym = ysb + c.ysv & 0x3FF;
            int gi = this.perm2D[this.perm[pxm] ^ pym];
            double extrapolation = GRADIENTS_2D[gi] * dx + GRADIENTS_2D[gi + 1] * dy;
            attn *= attn;
            value += attn * attn * extrapolation;
        }
        return value;
    }

    public double noise(double x, double y, double z) {
        double stretchOffset = (x + y + z) * -0.16666666666666666;
        double xs = x + stretchOffset;
        double ys = y + stretchOffset;
        double zs = z + stretchOffset;
        int xsb = SimplexOctave.fastFloor(xs);
        int ysb = SimplexOctave.fastFloor(ys);
        int zsb = SimplexOctave.fastFloor(zs);
        double squishOffset = (double)(xsb + ysb + zsb) * 0.3333333333333333;
        double dx0 = x - ((double)xsb + squishOffset);
        double dy0 = y - ((double)ysb + squishOffset);
        double dz0 = z - ((double)zsb + squishOffset);
        double xins = xs - (double)xsb;
        double yins = ys - (double)ysb;
        double zins = zs - (double)zsb;
        double inSum = xins + yins + zins;
        int hash = (int)(yins - zins + 1.0) | (int)(xins - yins + 1.0) << 1 | (int)(xins - zins + 1.0) << 2 | (int)inSum << 3 | (int)(inSum + zins) << 5 | (int)(inSum + yins) << 7 | (int)(inSum + xins) << 9;
        Contribution3 c = LOOKUP_3D[hash];
        double value = 0.0;
        while (c != null) {
            double dx = dx0 + c.dx;
            double dy = dy0 + c.dy;
            double dz = dz0 + c.dz;
            double attn = 2.0 - dx * dx - dy * dy - dz * dz;
            if (attn > 0.0) {
                int px = xsb + c.xsb;
                int py = ysb + c.ysb;
                int pz = zsb + c.zsb;
                int i = this.perm3D[(this.perm[(this.perm[px & 0x3FF] ^ py) & 0x3FF] ^ pz) & 0x3FF];
                double valuePart = GRADIENTS_3D[i] * dx + GRADIENTS_3D[i + 1] * dy + GRADIENTS_3D[i + 2] * dz;
                attn *= attn;
                value += attn * attn * valuePart;
            }
            c = c.next;
        }
        return value;
    }

    public static void noise(double x, double y, NoiseInstance2[] instances, double[] results) {
        double s = -0.211324865405187 * (x + y);
        double xs = x + s;
        double ys = y + s;
        int xsb = SimplexOctave.fastFloor(xs);
        int ysb = SimplexOctave.fastFloor(ys);
        double xsi = xs - (double)xsb;
        double ysi = ys - (double)ysb;
        int a = (int)(ysi - xsi + 1.0);
        int index = a << 2 | (int)(xsi + ysi / 2.0 + (double)a / 2.0) << 3 | (int)(ysi + xsi / 2.0 + 0.5 - (double)a / 2.0) << 4;
        double ssi = (xsi + ysi) * 0.366025403784439;
        double xi = xsi + ssi;
        double yi = ysi + ssi;
        for (int i = 0; i < 4; ++i) {
            LatticePoint2D c = LOOKUP_2D[index + i];
            double dx = xi + c.dx;
            double dy = yi + c.dy;
            double attn = 2.0 - dx * dx - dy * dy;
            if (attn <= 0.0) continue;
            double attnSq = attn * attn;
            int pxm = xsb + c.xsv & 0x3FF;
            int pym = ysb + c.ysv & 0x3FF;
            for (NoiseInstance2 instance : instances) {
                int gi_p = instance.noise.perm[pxm] ^ pym;
                int gi = instance.noise.perm2D[gi_p];
                double gx = GRADIENTS_2D[gi + 0];
                double gy = GRADIENTS_2D[gi + 1];
                double extrapolation = gx * dx + gy * dy;
                if (instance.valueIndex >= 0) {
                    int n = instance.valueIndex;
                    results[n] = results[n] + attnSq * attnSq * extrapolation;
                }
                if ((instance.ddxIndex & instance.ddyIndex) >= 0) {
                    if (instance.ddxIndex >= 0) {
                        int n = instance.ddxIndex;
                        results[n] = results[n] + (gx * attn - 8.0 * dx * extrapolation) * attnSq * attn;
                    }
                    if (instance.ddyIndex >= 0) {
                        int n = instance.ddyIndex;
                        results[n] = results[n] + (gy * attn - 8.0 * dy * extrapolation) * attnSq * attn;
                    }
                }
                if ((instance.sph2xIndex & instance.sph2yIndex) < 0) continue;
                int gi_sph2 = instance.noise.perm2D_sph2[gi_p];
                if (instance.sph2xIndex >= 0) {
                    int n = instance.sph2xIndex;
                    results[n] = results[n] + attnSq * attnSq * extrapolation * GRADIENTS_SPH2[gi_sph2 + 0];
                }
                if (instance.sph2yIndex < 0) continue;
                int n = instance.sph2yIndex;
                results[n] = results[n] + attnSq * attnSq * extrapolation * GRADIENTS_SPH2[gi_sph2 + 1];
            }
        }
    }

    public void evaluateNoise(double x, double y, DataStore data) {
        double s = -0.211324865405187 * (x + y);
        double xs = x + s;
        double ys = y + s;
        int xsb = SimplexOctave.fastFloor(xs);
        int ysb = SimplexOctave.fastFloor(ys);
        double xsi = xs - (double)xsb;
        double ysi = ys - (double)ysb;
        int a = (int)(ysi - xsi + 1.0);
        int index = a << 2 | (int)(xsi + ysi / 2.0 + (double)a / 2.0) << 3 | (int)(ysi + xsi / 2.0 + 0.5 - (double)a / 2.0) << 4;
        double ssi = (xsi + ysi) * 0.366025403784439;
        double xi = xsi + ssi;
        double yi = ysi + ssi;
        data.clear();
        for (int i = 0; i < 4; ++i) {
            LatticePoint2D c = LOOKUP_2D[index + i];
            double dx = xi + c.dx;
            double dy = yi + c.dy;
            double attn = 2.0 - dx * dx - dy * dy;
            if (attn <= 0.0) continue;
            int pxm = xsb + c.xsv & 0x3FF;
            int pym = ysb + c.ysv & 0x3FF;
            int gi_p = this.perm[pxm] ^ pym;
            int gi = this.perm2D[gi_p];
            double gx = GRADIENTS_2D[gi + 0];
            double gy = GRADIENTS_2D[gi + 1];
            double extrapolation = gx * dx + gy * dy;
            int gi_sph2 = this.perm2D_sph2[gi_p];
            data.request().record(attn, extrapolation, gx, gy, gi_sph2, dx, dy);
        }
    }

    private static int fastFloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    static {
        int i;
        LOOKUP_2D = new LatticePoint2D[32];
        for (int i2 = 0; i2 < 8; ++i2) {
            int j2;
            int i22;
            int j1;
            int i1;
            if ((i2 & 1) == 0) {
                if ((i2 & 2) == 0) {
                    i1 = 0;
                    j1 = 0;
                } else {
                    i1 = 2;
                    j1 = 0;
                }
                if ((i2 & 4) == 0) {
                    i22 = 1;
                    j2 = -1;
                } else {
                    i22 = 1;
                    j2 = 1;
                }
            } else {
                if ((i2 & 2) == 0) {
                    i1 = -1;
                    j1 = 1;
                } else {
                    i1 = 1;
                    j1 = 1;
                }
                if ((i2 & 4) == 0) {
                    i22 = 0;
                    j2 = 0;
                } else {
                    i22 = 0;
                    j2 = 2;
                }
            }
            SimplexOctave.LOOKUP_2D[i2 * 4 + 0] = new LatticePoint2D(1, 0);
            SimplexOctave.LOOKUP_2D[i2 * 4 + 1] = new LatticePoint2D(0, 1);
            SimplexOctave.LOOKUP_2D[i2 * 4 + 2] = new LatticePoint2D(i1, j1);
            SimplexOctave.LOOKUP_2D[i2 * 4 + 3] = new LatticePoint2D(i22, j2);
        }
        int[][] base3D = new int[][]{{0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1}, {2, 1, 1, 0, 2, 1, 0, 1, 2, 0, 1, 1, 3, 1, 1, 1}, {1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 2, 1, 1, 0, 2, 1, 0, 1, 2, 0, 1, 1}};
        int[] p3D = new int[]{0, 0, 1, -1, 0, 0, 1, 0, -1, 0, 0, -1, 1, 0, 0, 0, 1, -1, 0, 0, -1, 0, 1, 0, 0, -1, 1, 0, 2, 1, 1, 0, 1, 1, 1, -1, 0, 2, 1, 0, 1, 1, 1, -1, 1, 0, 2, 0, 1, 1, 1, -1, 1, 1, 1, 3, 2, 1, 0, 3, 1, 2, 0, 1, 3, 2, 0, 1, 3, 1, 0, 2, 1, 3, 0, 2, 1, 3, 0, 1, 2, 1, 1, 1, 0, 0, 2, 2, 0, 0, 1, 1, 0, 1, 0, 2, 0, 2, 0, 1, 1, 0, 0, 1, 2, 0, 0, 2, 2, 0, 0, 0, 0, 1, 1, -1, 1, 2, 0, 0, 0, 0, 1, -1, 1, 1, 2, 0, 0, 0, 0, 1, 1, 1, -1, 2, 3, 1, 1, 1, 2, 0, 0, 2, 2, 3, 1, 1, 1, 2, 2, 0, 0, 2, 3, 1, 1, 1, 2, 0, 2, 0, 2, 1, 1, -1, 1, 2, 0, 0, 2, 2, 1, 1, -1, 1, 2, 2, 0, 0, 2, 1, -1, 1, 1, 2, 0, 0, 2, 2, 1, -1, 1, 1, 2, 0, 2, 0, 2, 1, 1, 1, -1, 2, 2, 0, 0, 2, 1, 1, 1, -1, 2, 0, 2, 0};
        int[] lookupPairs3D = new int[]{0, 2, 1, 1, 2, 2, 5, 1, 6, 0, 7, 0, 32, 2, 34, 2, 129, 1, 133, 1, 160, 5, 161, 5, 518, 0, 519, 0, 546, 4, 550, 4, 645, 3, 647, 3, 672, 5, 673, 5, 674, 4, 677, 3, 678, 4, 679, 3, 680, 13, 681, 13, 682, 12, 685, 14, 686, 12, 687, 14, 712, 20, 714, 18, 809, 21, 813, 23, 840, 20, 841, 21, 1198, 19, 1199, 22, 1226, 18, 1230, 19, 1325, 23, 1327, 22, 1352, 15, 1353, 17, 1354, 15, 1357, 17, 1358, 16, 1359, 16, 1360, 11, 1361, 10, 1362, 11, 1365, 10, 1366, 9, 1367, 9, 1392, 11, 1394, 11, 1489, 10, 1493, 10, 1520, 8, 1521, 8, 1878, 9, 1879, 9, 1906, 7, 1910, 7, 2005, 6, 2007, 6, 2032, 8, 2033, 8, 2034, 7, 2037, 6, 2038, 7, 2039, 6};
        Contribution3[] contributions3D = new Contribution3[p3D.length / 9];
        for (i = 0; i < p3D.length; i += 9) {
            int[] baseSet = base3D[p3D[i]];
            Contribution3 previous = null;
            Contribution3 current = null;
            for (int k = 0; k < baseSet.length; k += 4) {
                current = new Contribution3(baseSet[k], baseSet[k + 1], baseSet[k + 2], baseSet[k + 3]);
                if (previous == null) {
                    contributions3D[i / 9] = current;
                } else {
                    previous.next = current;
                }
                previous = current;
            }
            current.next = new Contribution3(p3D[i + 1], p3D[i + 2], p3D[i + 3], p3D[i + 4]);
            current.next.next = new Contribution3(p3D[i + 5], p3D[i + 6], p3D[i + 7], p3D[i + 8]);
        }
        LOOKUP_3D = new Contribution3[2048];
        for (i = 0; i < lookupPairs3D.length; i += 2) {
            SimplexOctave.LOOKUP_3D[lookupPairs3D[i]] = contributions3D[lookupPairs3D[i + 1]];
        }
        GRADIENTS_2D = new double[]{0.114251372530929, 0.065963060686016, 0.131926121372032, 0.0, 0.114251372530929, -0.065963060686016, 0.065963060686016, -0.114251372530929, 0.0, -0.131926121372032, -0.065963060686016, -0.114251372530929, -0.114251372530929, -0.065963060686016, -0.131926121372032, -0.0, -0.114251372530929, 0.065963060686016, -0.065963060686016, 0.114251372530929, -0.0, 0.131926121372032, 0.065963060686016, 0.114251372530929};
        GRADIENTS_SPH2 = new double[]{0.0, 1.0, 0.5, 0.866025403784439, 0.866025403784439, 0.5, 1.0, 0.0, 0.866025403784439, -0.5, 0.5, -0.866025403784439, 0.0, -1.0, -0.5, -0.866025403784439, -0.866025403784439, -0.5, -1.0, 0.0, -0.866025403784439, 0.5, -0.5, 0.866025403784439};
        GRADIENTS_3D = new double[]{-0.00919201927982, 0.061948581592974, 0.10551312462631, 0.061948581592974, -0.00919201927982, 0.10551312462631, 0.052339395980958, 0.052339395980958, 0.097858646551677, 0.002784312704445, 0.002784312704445, 0.122636188189934, -0.00919201927982, 0.10551312462631, 0.061948581592974, 0.061948581592974, 0.10551312462631, -0.00919201927982, 0.052339395980958, 0.097858646551677, 0.052339395980958, 0.002784312704445, 0.122636188189934, 0.002784312704445, 0.10551312462631, -0.00919201927982, 0.061948581592974, 0.10551312462631, 0.061948581592974, -0.00919201927982, 0.097858646551677, 0.052339395980958, 0.052339395980958, 0.122636188189934, 0.002784312704445, 0.002784312704445, -0.0672780766576, 0.090991610281865, 0.047427067248529, -0.090991610281865, 0.0672780766576, -0.047427067248529, -0.057908021389848, 0.107463104666361, -0.012388770819128, -0.107463104666361, 0.057908021389848, 0.012388770819128, -0.0672780766576, 0.047427067248529, 0.090991610281865, -0.090991610281865, -0.047427067248529, 0.0672780766576, -0.057908021389848, -0.012388770819128, 0.107463104666361, -0.107463104666361, 0.012388770819128, 0.057908021389848, 0.047427067248529, -0.0672780766576, 0.090991610281865, -0.047427067248529, -0.090991610281865, 0.0672780766576, -0.012388770819128, -0.057908021389848, 0.107463104666361, 0.012388770819128, -0.107463104666361, 0.057908021389848, 0.0672780766576, -0.090991610281865, -0.047427067248529, 0.090991610281865, -0.0672780766576, 0.047427067248529, 0.107463104666361, -0.057908021389848, -0.012388770819128, 0.057908021389848, -0.107463104666361, 0.012388770819128, 0.0672780766576, -0.047427067248529, -0.090991610281865, 0.090991610281865, 0.047427067248529, -0.0672780766576, 0.107463104666361, -0.012388770819128, -0.057908021389848, 0.057908021389848, 0.012388770819128, -0.107463104666361, -0.047427067248529, 0.0672780766576, -0.090991610281865, 0.047427067248529, 0.090991610281865, -0.0672780766576, -0.012388770819128, 0.107463104666361, -0.057908021389848, 0.012388770819128, 0.057908021389848, -0.107463104666361, 0.00919201927982, -0.061948581592974, -0.10551312462631, -0.061948581592974, 0.00919201927982, -0.10551312462631, -0.002784312704445, -0.002784312704445, -0.122636188189934, -0.052339395980958, -0.052339395980958, -0.097858646551677, 0.00919201927982, -0.10551312462631, -0.061948581592974, -0.061948581592974, -0.10551312462631, 0.00919201927982, -0.002784312704445, -0.122636188189934, -0.002784312704445, -0.052339395980958, -0.097858646551677, -0.052339395980958, -0.10551312462631, 0.00919201927982, -0.061948581592974, -0.10551312462631, -0.061948581592974, 0.00919201927982, -0.122636188189934, -0.002784312704445, -0.002784312704445, -0.097858646551677, -0.052339395980958, -0.052339395980958};
    }

    public static class NoiseInstance2 {
        public SimplexOctave noise;
        public int valueIndex;
        public int ddxIndex;
        public int ddyIndex;
        public int sph2xIndex;
        public int sph2yIndex;

        public NoiseInstance2(SimplexOctave noise, int valueIndex, int ddxIndex, int ddyIndex, int sph2xIndex, int sph2yIndex) {
            this.noise = noise;
            this.valueIndex = valueIndex;
            this.ddxIndex = ddxIndex;
            this.ddyIndex = ddyIndex;
            this.sph2xIndex = sph2xIndex;
            this.sph2yIndex = sph2yIndex;
        }

        public NoiseInstance2(SimplexOctave noise, int valueIndex, int ddxIndex, int ddyIndex) {
            this(noise, valueIndex, ddxIndex, ddyIndex, -1, -1);
        }

        public NoiseInstance2(SimplexOctave noise, int valueIndex) {
            this(noise, valueIndex, -1, -1, -1, -1);
        }
    }

    private static class Contribution3 {
        public double dx;
        public double dy;
        public double dz;
        public int xsb;
        public int ysb;
        public int zsb;
        public Contribution3 next;

        public Contribution3(double multiplier, int xsb, int ysb, int zsb) {
            this.dx = (double)(-xsb) - multiplier * 0.3333333333333333;
            this.dy = (double)(-ysb) - multiplier * 0.3333333333333333;
            this.dz = (double)(-zsb) - multiplier * 0.3333333333333333;
            this.xsb = xsb;
            this.ysb = ysb;
            this.zsb = zsb;
        }
    }

    private static class LatticePoint2D {
        public int xsv;
        public int ysv;
        public double dx;
        public double dy;

        public LatticePoint2D(int xsv, int ysv) {
            this.xsv = xsv;
            this.ysv = ysv;
            double ssv = (double)(xsv + ysv) * 0.366025403784439;
            this.dx = (double)(-xsv) - ssv;
            this.dy = (double)(-ysv) - ssv;
        }
    }

    public static class Scalar
    extends DataStore {
        private final DataRequest request = new Request();
        private double value;

        @Override
        void clear() {
            this.value = 0.0;
        }

        public final double value() {
            return this.value;
        }

        @Override
        DataRequest request() {
            return this.request;
        }

        private class Request
        implements DataRequest {
            private Request() {
            }

            @Override
            public final void record(double attn, double extrapolation, double gx, double gy, int gi_sph2, double dx, double dy) {
                double attnSq = attn * attn;
                Scalar.this.value = Scalar.this.value + attnSq * attnSq * extrapolation;
            }
        }
    }

    public static class Derivative
    extends DataStore {
        private final DataRequest request = new Request();
        private double deltax;
        private double deltay;

        @Override
        void clear() {
            this.deltax = 0.0;
            this.deltay = 0.0;
        }

        public final double deltax() {
            return this.deltax;
        }

        public final double deltay() {
            return this.deltay;
        }

        @Override
        DataRequest request() {
            return this.request;
        }

        private class Request
        implements DataRequest {
            private Request() {
            }

            @Override
            public final void record(double attn, double extrapolation, double gx, double gy, int gi_sph2, double dx, double dy) {
                double attnSq = attn * attn;
                Derivative.this.deltax = Derivative.this.deltax + (gx * attn - 8.0 * dx * extrapolation) * attnSq * attn;
                Derivative.this.deltay = Derivative.this.deltay + (gy * attn - 8.0 * dy * extrapolation) * attnSq * attn;
            }
        }
    }

    public static class Disk
    extends DataStore {
        private final DataRequest request = new Request();
        private double deltax;
        private double deltay;

        @Override
        void clear() {
            this.deltax = 0.0;
            this.deltay = 0.0;
        }

        public final double deltax() {
            return this.deltax;
        }

        public final double deltay() {
            return this.deltay;
        }

        @Override
        DataRequest request() {
            return this.request;
        }

        private class Request
        implements DataRequest {
            private Request() {
            }

            @Override
            public final void record(double attn, double extrapolation, double gx, double gy, int gi_sph2, double dx, double dy) {
                double attnSq = attn * attn;
                Disk.this.deltax = Disk.this.deltax + attnSq * attnSq * extrapolation * GRADIENTS_SPH2[gi_sph2 + 0];
                Disk.this.deltay = Disk.this.deltay + attnSq * attnSq * extrapolation * GRADIENTS_SPH2[gi_sph2 + 1];
            }
        }
    }

    public static abstract class DataStore {
        abstract DataRequest request();

        abstract void clear();
    }

    private static interface DataRequest {
        public void record(double var1, double var3, double var5, double var7, int var9, double var10, double var12);
    }
}

