/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import rtg.util.CellOctave;

public class SimplexCellularOctave
implements CellOctave {
    private short[] perm;
    private short[] perm2D;
    private int f1Index = 0;
    private int f2Index = 1;
    private double[] extantX = new double[9];
    private double[] extantY = new double[9];
    private int extant = 0;
    private int[] pointIndex = new int[2];
    private static String otherSide = null;
    public static boolean crashing = false;
    public static String chunkManagerProblems = "";
    private static final LatticePoint2D[] LOOKUP_2D = new LatticePoint2D[162];
    private static final double[] JITTER_2D;

    public SimplexCellularOctave(long seed) {
        int i;
        this.perm = new short[1024];
        this.perm2D = new short[1024];
        short[] source = new short[1024];
        for (i = 0; i < 1024; i = (int)((short)(i + 1))) {
            source[i] = i;
        }
        for (i = 1023; i >= 0; --i) {
            int r = (int)(((seed = seed * 6364136223846793005L + 1442695040888963407L) + 31L) % (long)(i + 1));
            if (r < 0) {
                r += i + 1;
            }
            this.perm[i] = source[r];
            this.perm2D[i] = (short)(this.perm[i] % 12 * 2);
            source[r] = source[i];
        }
    }

    private boolean tooClose(double thisX, double thisY) {
        boolean tooClose = false;
        for (int j = 0; j < this.extant; ++j) {
            double fromX = thisX - this.extantX[j];
            double fromY = thisY - this.extantY[j];
            if (!(fromX * fromX + fromY * fromY < 0.002)) continue;
            return true;
        }
        this.extantX[this.extant] = thisX;
        this.extantY[this.extant++] = thisY;
        return tooClose;
    }

    private int pointTooClose(double thisX, double thisY) {
        for (int j = 0; j < this.extant; ++j) {
            double fromX = thisX - this.extantX[j];
            double fromY = thisY - this.extantY[j];
            if (fromX * fromX + fromY * fromY < 0.002) {
                return j;
            }
            if (!(fromX * fromX + fromY * fromY < 0.004)) continue;
            throw new RuntimeException();
        }
        this.extantX[this.extant] = thisX;
        this.extantY[this.extant] = thisY;
        ++this.extant;
        return -1;
    }

    @Override
    public double[] eval(double x, double y) {
        this.extant = 0;
        double[] results = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        this.pointIndex[0] = -2;
        this.pointIndex[1] = -2;
        double s = 0.366025403784439 * (x + y);
        double xs = x + s;
        double ys = y + s;
        String complaint = null;
        int xsb = SimplexCellularOctave.fastFloor(xs);
        int ysb = SimplexCellularOctave.fastFloor(ys);
        double xsi = xs - (double)xsb;
        double ysi = ys - (double)ysb;
        int index = (int)(xsi + ysi) * 9 + (int)(xsi * 2.0 - ysi + 1.0) * 9 * 2 + (int)(ysi * 2.0 - xsi + 1.0) * 9 * 6;
        double ssi = (xsi + ysi) * -0.211324865405187;
        double xi = xsi + ssi;
        double yi = ysi + ssi;
        if (crashing) {
            complaint = "" + x;
            complaint = complaint + " " + y;
            complaint = complaint + " " + (int)(x * 1875.0);
            complaint = complaint + " " + (int)(y * 1875.0);
        }
        for (int i = 0; i < 9; ++i) {
            int closeTo;
            LatticePoint2D c = LOOKUP_2D[index + i];
            int pxm = xsb + c.xsv & 0x3FF;
            int pym = ysb + c.ysv & 0x3FF;
            short ji = this.perm2D[this.perm[pxm] ^ pym];
            double jx = JITTER_2D[ji + 0];
            double jy = JITTER_2D[ji + 1];
            double djx = jx - (c.dx + xi);
            double djy = jy - (c.dy + yi);
            double distance = Math.sqrt(djx * djx + djy * djy);
            if (crashing) {
                complaint = complaint + "" + i + " " + (jx - c.dx) + " " + (jy - c.dy) + " " + distance + " ";
            }
            if ((closeTo = this.pointTooClose(jx - c.dx, jy - c.dy)) != -1) {
                if (this.pointIndex[this.f1Index] == i && distance < results[this.f1Index]) {
                    results[this.f1Index] = distance;
                    this.pointIndex[this.f1Index] = i;
                }
                if (this.pointIndex[this.f2Index] != i) continue;
                if (distance < results[this.f1Index]) {
                    results[this.f2Index] = results[this.f1Index];
                    this.pointIndex[this.f2Index] = this.pointIndex[this.f1Index];
                    results[this.f1Index] = distance;
                    this.pointIndex[this.f1Index] = i;
                    continue;
                }
                if (!(distance < results[this.f2Index])) continue;
                results[this.f2Index] = distance;
                this.pointIndex[this.f2Index] = i;
                continue;
            }
            if (this.f2Index >= 0) {
                if (!(distance < results[this.f2Index])) continue;
                results[this.f2Index] = distance;
                this.pointIndex[this.f2Index] = i;
                if (!(distance < results[this.f1Index])) continue;
                results[this.f2Index] = results[this.f1Index];
                this.pointIndex[this.f2Index] = this.pointIndex[this.f1Index];
                results[this.f1Index] = distance;
                this.pointIndex[this.f1Index] = i;
                continue;
            }
            if (this.f1Index < 0 || !(distance < results[this.f1Index])) continue;
            results[this.f1Index] = distance;
            this.pointIndex[this.f1Index] = i;
        }
        if (crashing) {
            complaint = complaint + this.pointIndex[this.f1Index] + " " + results[this.f1Index] + " ";
            complaint = complaint + this.pointIndex[this.f2Index] + " " + results[this.f2Index] + " ";
            if (otherSide != null) {
                throw new RuntimeException(otherSide + "        " + complaint + " " + chunkManagerProblems);
            }
            otherSide = complaint;
            crashing = false;
        }
        if (results[0] > results[1]) {
            throw new RuntimeException();
        }
        return results;
    }

    public static double[] initResultArray(NoiseInstance2[] instances) {
        int max = 0;
        for (NoiseInstance2 instance : instances) {
            if (instance.f1Index > max) {
                max = instance.f1Index;
            }
            if (instance.f2Index <= max) continue;
            max = instance.f2Index;
        }
        double[] destination = new double[max + 1];
        return destination;
    }

    public static void resetResultArray(NoiseInstance2[] instances, double[] results) {
        for (NoiseInstance2 instance : instances) {
            if (instance.f1Index >= 0) {
                results[instance.f1Index] = Double.POSITIVE_INFINITY;
            }
            if (instance.f2Index < 0) continue;
            results[instance.f2Index] = Double.POSITIVE_INFINITY;
        }
    }

    private static int fastFloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    @Override
    public float noise(double x, double z, double depth) {
        return (float)this.eval(x, z)[0];
    }

    static {
        for (int i = 0; i < 18; ++i) {
            int j5;
            int i5;
            int j4;
            int i4;
            int j3;
            int i3;
            int j2;
            int i2;
            int j1;
            int i1;
            int a = i & 1;
            int b = i / 2 % 3;
            int c = i / 6 % 3;
            if (a == 0) {
                i1 = -1;
                j1 = -1;
            } else {
                i1 = 2;
                j1 = 2;
            }
            if (b < 2) {
                i2 = -1;
                j2 = 0;
            } else {
                i2 = 2;
                j2 = 0;
            }
            if (b < 1) {
                i3 = -1;
                j3 = 1;
            } else {
                i3 = 2;
                j3 = 1;
            }
            if (c < 2) {
                i4 = 0;
                j4 = -1;
            } else {
                i4 = 0;
                j4 = 2;
            }
            if (c < 1) {
                i5 = 1;
                j5 = -1;
            } else {
                i5 = 1;
                j5 = 2;
            }
            SimplexCellularOctave.LOOKUP_2D[i * 9 + 0] = new LatticePoint2D(0, 0);
            SimplexCellularOctave.LOOKUP_2D[i * 9 + 1] = new LatticePoint2D(1, 0);
            SimplexCellularOctave.LOOKUP_2D[i * 9 + 2] = new LatticePoint2D(0, 1);
            SimplexCellularOctave.LOOKUP_2D[i * 9 + 3] = new LatticePoint2D(1, 1);
            SimplexCellularOctave.LOOKUP_2D[i * 9 + 4] = new LatticePoint2D(i1, j1);
            SimplexCellularOctave.LOOKUP_2D[i * 9 + 5] = new LatticePoint2D(i2, j2);
            SimplexCellularOctave.LOOKUP_2D[i * 9 + 6] = new LatticePoint2D(i3, j3);
            SimplexCellularOctave.LOOKUP_2D[i * 9 + 7] = new LatticePoint2D(i4, j4);
            SimplexCellularOctave.LOOKUP_2D[i * 9 + 8] = new LatticePoint2D(i5, j5);
        }
        JITTER_2D = new double[]{0.0, 0.408248290463863, 0.204124145231932, 0.353553390593274, 0.353553390593274, 0.204124145231932, 0.408248290463863, 0.0, 0.353553390593274, -0.204124145231932, 0.204124145231932, -0.353553390593274, 0.0, -0.408248290463863, -0.204124145231932, -0.353553390593274, -0.353553390593274, -0.204124145231932, -0.408248290463863, 0.0, -0.353553390593274, 0.204124145231932, -0.204124145231932, 0.353553390593274};
    }

    public static class NoiseInstance2 {
        public SimplexCellularOctave noise;
        public int f1Index;
        public int f2Index;

        public NoiseInstance2(SimplexCellularOctave noise, int f1Index, int f2Index) {
            this.noise = noise;
            this.f1Index = f1Index;
            this.f2Index = f2Index;
        }
    }

    private static class LatticePoint2D {
        public int xsv;
        public int ysv;
        public double dx;
        public double dy;

        public LatticePoint2D(int xsv, int ysv) {
            this.xsv = xsv;
            this.ysv = ysv;
            double ssv = (double)(xsv + ysv) * -0.211324865405187;
            this.dx = (double)(-xsv) - ssv;
            this.dy = (double)(-ysv) - ssv;
        }
    }
}

