/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import java.util.Comparator;

public abstract class PlaneLocation {
    public abstract int x();

    public abstract int z();

    public float distance(PlaneLocation location) {
        return (float)(this.x() - location.x()) * (float)(this.x() - location.x()) + (float)(this.z() - location.z()) * (float)(this.z() - location.z());
    }

    public <Type extends Provider> Type closest(Iterable<Type> choices) {
        Provider result = null;
        float bestDistance = Float.MAX_VALUE;
        for (Provider tested : choices) {
            float distance = this.distance(tested.planeLocation());
            if (!(distance < bestDistance)) continue;
            result = tested;
        }
        return (Type)result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.x();
        hash = 71 * hash + this.z();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlaneLocation)) {
            return false;
        }
        PlaneLocation other = (PlaneLocation)obj;
        if (this.x() != other.x()) {
            return false;
        }
        return this.z() == other.z();
    }

    public String toString() {
        return "(" + this.x() + "," + this.z() + ")";
    }

    public static Comparator<PlaneLocation> topLefttoBottomRight() {
        return new Comparator<PlaneLocation>(){

            @Override
            public int compare(PlaneLocation arg0, PlaneLocation arg1) {
                int result = arg0.x() - arg1.x();
                if (result == 0) {
                    return arg0.z() - arg1.z();
                }
                return result;
            }
        };
    }

    public static class Invariant
    extends PlaneLocation {
        private final int x;
        private final int z;

        public Invariant(int _x, int _z) {
            this.x = _x;
            this.z = _z;
        }

        @Override
        public int x() {
            return this.x;
        }

        @Override
        public int z() {
            return this.z;
        }
    }

    public static class Probe
    extends PlaneLocation {
        private int x;
        private int z;

        public Probe(int _x, int _z) {
            this.x = _x;
            this.z = _z;
        }

        @Override
        public int x() {
            return this.x;
        }

        @Override
        public int z() {
            return this.z;
        }

        public void setX(int newX) {
            this.x = newX;
        }

        public void setZ(int newZ) {
            this.z = newZ;
        }
    }

    public abstract class Provider {
        public abstract PlaneLocation planeLocation();
    }
}

