/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import rtg.util.Acceptor;
import rtg.util.Named;
import rtg.util.NamedConverter;

public abstract class Converter<FromType, ToType> {
    public abstract ToType result(FromType var1);

    public ToType of(FromType original) {
        return this.result(original);
    }

    public Collection<ToType> listResult(Collection<FromType> source) {
        ArrayList<ToType> result = new ArrayList<ToType>(source.size());
        Iterator<FromType> sourceList = source.iterator();
        while (sourceList.hasNext()) {
            result.add(this.result(sourceList.next()));
        }
        return result;
    }

    public Acceptor<FromType> acceptor(final Acceptor<ToType> target) {
        return new Acceptor<FromType>(){

            @Override
            public void accept(FromType accepted) {
                target.accept(Converter.this.result(accepted));
            }
        };
    }

    public <FinalType> Converter<FromType, FinalType> composedWith(Converter<ToType, FinalType> following) {
        return new ChainTo<FinalType>(following);
    }

    public Converter<Named<FromType>, Named<ToType>> namer() {
        return new NamedConverter(this);
    }

    public <FromType, Type2, Type3> Iterator<Type3> forEach(Converter<FromType, Converter<Type2, Type3>> converterizer, Iterator<Type2> data) {
        return null;
    }

    public static class Constant<CFromType, CToType>
    extends Converter<CFromType, CToType> {
        private final CToType value;

        public Constant(CToType theValue) {
            this.value = theValue;
        }

        @Override
        public CToType result(CFromType original) {
            return this.value;
        }
    }

    public class ChainTo<FinalType>
    extends Converter<FromType, FinalType> {
        Converter<ToType, FinalType> finalizer;

        public ChainTo(Converter<ToType, FinalType> theFinalizer) {
            this.finalizer = theFinalizer;
        }

        @Override
        public FinalType result(FromType original) {
            return this.finalizer.result(Converter.this.result(original));
        }
    }

    class IteratorConverter
    implements Iterator<ToType> {
        Iterator<? extends FromType> source;

        IteratorConverter(Iterator<? extends FromType> theSource) {
            this.source = theSource;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public ToType next() {
            return Converter.this.result(this.source.next());
        }

        @Override
        public void remove() {
            this.source.remove();
        }
    }
}

