/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import rtg.config.rtg.ConfigRTG;
import rtg.util.OpenSimplexNoise;

public enum CanyonColour {
    MESA(ConfigRTG.mesaPlateauBlockMetas),
    MESA_BRYCE(ConfigRTG.mesaBrycePlateauBlockMetas),
    SAVANNA(ConfigRTG.savannaPlateauBlockMetas);

    private static Map<CanyonColour, Block[]> colourBlocks;
    private static Map<CanyonColour, byte[]> colourMetas;
    private static OpenSimplexNoise simplex;
    private byte[] bytes;
    private static Block plateauBlock;
    private static byte plateauBlockMeta;
    private static Block plateauGradientBlock;

    private CanyonColour(byte[] bytes) {
        this.bytes = bytes;
    }

    public static void init(long l) {
        simplex = new OpenSimplexNoise(l);
        for (CanyonColour colour : CanyonColour.values()) {
            Block[] c = new Block[256];
            byte[] cm = new byte[256];
            for (int i = 0; i < 256; ++i) {
                byte b = colour.bytes[i % colour.bytes.length];
                c[i] = b == -1 ? plateauBlock : plateauGradientBlock;
                cm[i] = b == -1 ? plateauBlockMeta : b;
            }
            colourBlocks.put(colour, c);
            colourMetas.put(colour, cm);
        }
    }

    public Block getBlockForHeight(int x, int y, int z) {
        return this.getBlockForHeight(x, (float)y, z);
    }

    public Block getBlockForHeight(int x, float y, int z) {
        float y1 = y + simplex.noise3((float)x / 80.0f, y / 6.0f, (float)z / 80.0f) * 3.0f;
        y1 = (y1 += simplex.noise2((float)x / 70.0f, (float)z / 70.0f) * 3.0f) < 0.0f ? 0.0f : (y1 > 255.0f ? 255.0f : y1);
        return colourBlocks.get((Object)this)[Math.round(y1)];
    }

    public byte getMetaForHeight(int x, int y, int z) {
        return this.getMetaForHeight(x, (float)y, z);
    }

    public byte getMetaForHeight(int x, float y, int z) {
        float y1 = y + simplex.noise3((float)x / 80.0f, y / 6.0f, (float)z / 80.0f) * 3.0f;
        y1 = (y1 += simplex.noise2((float)x / 70.0f, (float)z / 70.0f) * 3.0f) < 0.0f ? 0.0f : (y1 > 255.0f ? 255.0f : y1);
        return colourMetas.get((Object)this)[Math.round(y1)];
    }

    static {
        colourBlocks = new HashMap<CanyonColour, Block[]>();
        colourMetas = new HashMap<CanyonColour, byte[]>();
        plateauBlock = Block.func_149684_b((String)ConfigRTG.plateauBlockId);
        plateauBlockMeta = (byte)ConfigRTG.plateauBlockByte;
        plateauGradientBlock = Block.func_149684_b((String)ConfigRTG.plateauGradientBlockId);
    }
}

