/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import java.lang.reflect.Field;
import java.util.Arrays;

public class Accessor<ObjectType, FieldType> {
    private final String[] fieldNames;
    private Field field;

    public Accessor(String ... _fieldName) {
        this.fieldNames = _fieldName;
    }

    public FieldType get(ObjectType object) {
        try {
            return (FieldType)this.field(object).get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Field field(ObjectType example) {
        Class<?> classObject = example.getClass();
        if (this.field == null) {
            try {
                this.setField(classObject);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return this.field;
    }

    private void setField(Class classObject) throws IllegalAccessException {
        do {
            Field[] fields;
            for (Field field1 : fields = classObject.getDeclaredFields()) {
                for (String fieldName : this.fieldNames) {
                    if (!field1.getName().contains(fieldName)) continue;
                    this.field = field1;
                    this.field.setAccessible(true);
                    return;
                }
            }
        } while ((classObject = classObject.getSuperclass()) != Object.class);
        throw new RuntimeException("None of " + Arrays.toString(this.fieldNames) + " found in class " + classObject.getName());
    }

    public void setField(ObjectType object, FieldType fieldValue) {
        try {
            this.field(object).set(object, fieldValue);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }
}

