/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.tileentity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.tileentity.ModelGraveBase;
import de.maxhenkel.gravestone.tileentity.ModelGraveStone;
import de.maxhenkel.gravestone.tileentity.ModelHumanoidHead;
import de.maxhenkel.gravestone.tileentity.TileEntityGraveStone;
import de.maxhenkel.gravestone.util.BlockPos;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileentitySpecialRendererGraveStone
extends TileEntitySpecialRenderer {
    private boolean renderSkull;
    private ModelGraveBase graveModel;
    private ModelGraveStone graveModelStone;

    public TileentitySpecialRendererGraveStone() {
        this.renderSkull = Config.instance().renderSkull;
        this.graveModel = new ModelGraveBase();
        this.graveModelStone = new ModelGraveStone();
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float partialTicks) {
        if (!(te instanceof TileEntityGraveStone)) {
            return;
        }
        TileEntityGraveStone target = (TileEntityGraveStone)te;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glRotatef((float)this.getDirection(target.func_145832_p()), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(new ResourceLocation("minecraft:textures/blocks/dirt.png"));
        this.graveModel.func_78088_a(null, 0.0f, -0.1f, 0.0f, 0.0f, 0.0f, 0.0625f);
        this.func_147499_a(new ResourceLocation("minecraft:textures/blocks/cobblestone.png"));
        this.graveModelStone.func_78088_a(null, 0.0f, -0.1f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        String name = target.getPlayerName();
        if (name == null || name.isEmpty()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.5f));
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.getDirection(target.func_145832_p())), (float)0.0f, (float)1.0f, (float)0.0f);
        FontRenderer renderer = this.func_147498_b();
        if (renderer != null) {
            int textWidth = renderer.func_78256_a(name);
            float textScale = 0.8f / (float)textWidth;
            textScale = Math.min(textScale, 0.02f);
            GL11.glTranslatef((float)(-(textScale * (float)textWidth) / 2.0f), (float)0.3f, (float)0.37f);
            GL11.glScalef((float)textScale, (float)textScale, (float)textScale);
            GL11.glDepthMask((boolean)false);
            renderer.func_78276_b(name, 0, 0, 0);
            GL11.glDepthMask((boolean)true);
        }
        GL11.glPopMatrix();
        boolean render = false;
        BlockPos pos = new BlockPos(te.field_145851_c, te.field_145848_d, te.field_145849_e).down();
        Block block = target.func_145831_w().func_147439_a(pos.getX(), pos.getY(), pos.getZ());
        if (block == null) {
            return;
        }
        if (block.func_149662_c()) {
            render = true;
        }
        if (!target.renderHead() || target.getPlayerUUID() == null || target.getPlayerUUID().isEmpty() || !this.renderSkull || render) {
            // empty if block
        }
    }

    public void renderSkull(double x, double y, double z, float delta, GameProfile gameProfile, int rotation) {
        Minecraft minecraft;
        Map map;
        ModelHumanoidHead modelSkeletonHead = new ModelHumanoidHead();
        ResourceLocation resourcelocation = AbstractClientPlayer.field_110314_b;
        if (gameProfile != null && (map = (minecraft = Minecraft.func_71410_x()).func_152342_ad().func_152788_a(gameProfile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
        }
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glEnable((int)32826);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glEnable((int)3008);
        float yaw = 26.0f;
        float pitch = -61.0f;
        float scale = 0.0625f;
        GL11.glRotatef((float)(180 - this.getDirection(rotation)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.14f, (float)-0.18f);
        this.func_147499_a(resourcelocation);
        modelSkeletonHead.func_78088_a(null, 0.0f, 0.0f, 0.0f, yaw, pitch, scale);
        GL11.glPopMatrix();
    }

    private int getDirection(int i) {
        switch (i) {
            case 0: {
                return 0;
            }
            case 1: {
                return 270;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 90;
            }
        }
        return 0;
    }
}

