/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.recipes;

import buildcraft.api.recipes.IAssemblyRecipeManager;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.core.recipes.FlexibleRecipe;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class AssemblyRecipeManager
implements IAssemblyRecipeManager {
    public static final AssemblyRecipeManager INSTANCE = new AssemblyRecipeManager();
    private Map<String, IFlexibleRecipe<ItemStack>> assemblyRecipes = new HashMap<String, IFlexibleRecipe<ItemStack>>();

    @Override
    public void addRecipe(String id, int energyCost, ItemStack output, Object ... input) {
        this.addRecipe(id, new FlexibleRecipe<ItemStack>(id, output, energyCost, 0L, input));
    }

    @Override
    public void addRecipe(IFlexibleRecipe<ItemStack> recipe) {
        this.addRecipe(recipe.getId(), recipe);
    }

    private void addRecipe(String id, IFlexibleRecipe<ItemStack> recipe) {
        if (recipe == null) {
            throw new RuntimeException("Recipe \"" + id + "\" is null!");
        }
        if (this.assemblyRecipes.containsKey(id)) {
            throw new RuntimeException("Recipe \"" + id + "\" already registered");
        }
        this.assemblyRecipes.put(recipe.getId(), recipe);
    }

    @Override
    public Collection<IFlexibleRecipe<ItemStack>> getRecipes() {
        return this.assemblyRecipes.values();
    }

    public IFlexibleRecipe<ItemStack> getRecipe(String id) {
        return this.assemblyRecipes.get(id);
    }

    @Override
    public void removeRecipe(IFlexibleRecipe<ItemStack> recipe) {
        this.removeRecipe(recipe.getId());
    }

    @Override
    public void removeRecipe(String id) {
        this.assemblyRecipes.remove(id);
    }
}

