/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.entities.EntityRidableTurtle;
import com.austinv11.peripheralsplusplus.network.RidableTurtlePacket;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.turtles.TurtleRidable;
import com.austinv11.peripheralsplusplus.turtles.peripherals.MountedPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;

public class PeripheralRidable
extends MountedPeripheral {
    private final ITurtleAccess turtle;

    public PeripheralRidable(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "ridable";
    }

    public String[] getMethodNames() {
        return new String[]{"getEntity", "mountNearbyEntity", "unmount", "up"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableRidableTurtle) {
            throw new LuaException("Ridable turtles have been disabled.");
        }
        switch (method) {
            case 0: {
                return this.getRidingEntity();
            }
            case 1: {
                return this.mountNearbyEntity();
            }
            case 2: {
                return this.unmount();
            }
            case 3: {
                return this.up();
            }
        }
        return new Object[0];
    }

    private Object[] up() {
        boolean success;
        try {
            EntityRidableTurtle ridableTurtleEntity = TurtleRidable.getEntity(this.turtle);
            success = ridableTurtleEntity.canMoveUp();
            ridableTurtleEntity.queueAction(RidableTurtlePacket.MovementCode.ASCEND.code);
        }
        catch (Exception ignore) {
            return new Object[]{false};
        }
        return new Object[]{success};
    }

    private Object[] unmount() {
        try {
            EntityRidableTurtle ridableTurtleEntity = TurtleRidable.getEntity(this.turtle);
            ridableTurtleEntity.field_70153_n.func_70078_a(null);
        }
        catch (Exception e) {
            return new Object[]{false};
        }
        return new Object[]{true};
    }

    private Object[] mountNearbyEntity() {
        List entities = TurtleRidable.getNearbyEntities(this.turtle, 1, 2, Entity.class);
        Entity entity = null;
        for (Object ent : entities) {
            if (!((Entity)ent).func_70089_S() || ent instanceof EntityRidableTurtle) continue;
            entity = (Entity)ent;
            break;
        }
        try {
            EntityRidableTurtle ridableTurtleEntity = TurtleRidable.getEntity(this.turtle);
            if (entity == null || ridableTurtleEntity.field_70153_n != null) {
                return new Object[]{false};
            }
            entity.func_70078_a((Entity)ridableTurtleEntity);
        }
        catch (Exception e) {
            return new Object[]{false};
        }
        return new Object[]{true};
    }

    private Object[] getRidingEntity() {
        EntityRidableTurtle ridableTurtleEntity;
        try {
            ridableTurtleEntity = TurtleRidable.getEntity(this.turtle);
        }
        catch (Exception e) {
            return new Object[0];
        }
        Entity ridingEntity = ridableTurtleEntity.field_70153_n;
        HashMap<String, String> map = new HashMap<String, String>();
        if (ridingEntity != null) {
            map.put("name", ridingEntity instanceof EntityPlayer ? ((EntityPlayer)ridingEntity).getDisplayName() : EntityList.func_75621_b((Entity)ridingEntity));
            map.put("type", ridingEntity.getClass().getSimpleName());
            map.put("uuid", ridingEntity instanceof EntityPlayer ? ((EntityPlayer)ridingEntity).func_146103_bH().getId().toString() : ridingEntity.func_110124_au().toString());
        }
        return new Object[]{map};
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }
}

