/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.FakeTurtlePlayer;
import com.austinv11.peripheralsplusplus.utils.TurtleUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;

public class TurtleShear
implements ITurtleUpgrade {
    public int getUpgradeID() {
        return 107;
    }

    public String getUnlocalisedAdjective() {
        return "peripheralsplusplus.turtleUpgrade.shears";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Tool;
    }

    public ItemStack getCraftingItem() {
        if (Config.enableShearTurtle) {
            return new ItemStack((Item)Items.field_151097_aZ);
        }
        return null;
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return null;
    }

    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        if (!Config.enableShearTurtle) {
            return TurtleCommandResult.failure((String)"Shearing turtles have been disabled");
        }
        FakeTurtlePlayer player = new FakeTurtlePlayer(turtle);
        switch (verb) {
            case Attack: {
                List<Entity> entities = TurtleUtil.getEntitiesNearTurtle(turtle, player, direction);
                Entity ent = TurtleUtil.getClosestShearableEntity(entities, (Entity)player);
                if (ent != null && ((IShearable)ent).isShearable(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)ent.field_70170_p, (int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v)) {
                    TurtleUtil.addItemListToInv(((IShearable)ent).onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)ent.field_70170_p, (int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v, 0), turtle);
                    return TurtleCommandResult.success();
                }
                return TurtleCommandResult.failure();
            }
            case Dig: {
                List<ItemStack> items = TurtleUtil.harvestBlock(turtle, player, direction, new ItemStack((Item)Items.field_151097_aZ));
                if (items != null) {
                    TurtleUtil.addItemListToInv(items, turtle);
                    return TurtleCommandResult.success();
                }
                return TurtleCommandResult.failure();
            }
        }
        return TurtleCommandResult.failure((String)"An unknown error has occurred, please tell the mod author");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return Items.field_151097_aZ.func_77650_f(new ItemStack((Item)Items.field_151097_aZ));
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
    }
}

