/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.MountedTileEntity;
import com.austinv11.peripheralsplusplus.utils.ReflectionHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashMap;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Facing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileEntityTeleporter
extends MountedTileEntity {
    public static String publicName = "teleporter";
    private String name = "tileEntityTeleporter";
    public Stack<LinkData> links = new Stack();
    public String tag = null;

    public String getName() {
        return this.name;
    }

    public int getMaxLinks() {
        return 1;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("tTag")) {
            this.tag = nbttagcompound.func_74779_i("tTag");
        }
        NBTTagList links = nbttagcompound.func_150295_c("links", 10);
        for (int i = 0; i < links.func_74745_c(); ++i) {
            NBTTagCompound link = links.func_150305_b(i);
            if (!link.func_74764_b("linkX") || !link.func_74764_b("linkY") || !link.func_74764_b("linkZ") || !link.func_74764_b("linkDim")) continue;
            this.links.add(new LinkData(link.func_74762_e("linkDim"), new ChunkCoordinates(link.func_74762_e("linkX"), link.func_74762_e("linkY"), link.func_74762_e("linkZ"))));
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.tag != null) {
            nbttagcompound.func_74778_a("tTag", this.tag);
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.links.size(); ++i) {
            LinkData link = (LinkData)this.links.get(i);
            if (link == null) continue;
            NBTTagCompound lcompound = new NBTTagCompound();
            lcompound.func_74768_a("linkX", link.link.field_71574_a);
            lcompound.func_74768_a("linkY", link.link.field_71572_b);
            lcompound.func_74768_a("linkZ", link.link.field_71573_c);
            lcompound.func_74768_a("linkDim", link.linkDim);
            list.func_74742_a((NBTBase)lcompound);
        }
        nbttagcompound.func_74782_a("links", (NBTBase)list);
    }

    public String getType() {
        return publicName;
    }

    public String[] getMethodNames() {
        return new String[]{"teleport", "tp", "getLinks", "setName"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableTurtleTeleporter) {
            throw new LuaException("Turtle teleporters have been disabled");
        }
        if (method == 0 || method == 1) {
            int linkToZ;
            int linkToY;
            int index;
            if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                throw new LuaException("Bad argument #1 (expected number)");
            }
            int n = index = arguments.length > 0 ? (int)Math.floor((Double)arguments[0]) - 1 : 0;
            if (index < 0 || index >= this.getMaxLinks()) {
                throw new LuaException("Bad link " + (index + 1) + " (expected 1-" + this.getMaxLinks() + ")");
            }
            if (index >= this.links.size()) {
                throw new LuaException("No such link");
            }
            LinkData link = (LinkData)this.links.get(index);
            if (link == null) {
                throw new LuaException("No such link");
            }
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + Facing.field_71586_b[this.func_145832_p()], this.field_145848_d + Facing.field_71587_c[this.func_145832_p()], this.field_145849_e + Facing.field_71585_d[this.func_145832_p()]);
            try {
                if (ReflectionHelper.getTurtle(te) == null) {
                    throw new LuaException("No turtle in front");
                }
            }
            catch (Exception e) {
                throw new LuaException("No turtle in front");
            }
            WorldServer destWorld = MinecraftServer.func_71276_C().func_71218_a(link.linkDim);
            if (destWorld == null) {
                throw new LuaException("Destination world missing");
            }
            TileEntity dest = destWorld.func_147438_o(link.link.field_71574_a, link.link.field_71572_b, link.link.field_71573_c);
            if (!(dest instanceof TileEntityTeleporter)) {
                throw new LuaException("Destination is not a teleporter");
            }
            TileEntityTeleporter teleporter = (TileEntityTeleporter)dest;
            int linkToX = link.link.field_71574_a + Facing.field_71586_b[teleporter.func_145832_p()];
            if (destWorld.func_72899_e(linkToX, linkToY = link.link.field_71572_b + Facing.field_71587_c[teleporter.func_145832_p()], linkToZ = link.link.field_71573_c + Facing.field_71585_d[teleporter.func_145832_p()]) && !destWorld.func_147437_c(linkToX, linkToY, linkToZ) || linkToY < 0 || linkToY > 254) {
                throw new LuaException("Destination obstructed");
            }
            int xdif = Math.abs(this.field_145851_c - link.link.field_71574_a);
            int ydif = Math.abs(this.field_145848_d - link.link.field_71572_b);
            int zdif = Math.abs(this.field_145849_e - link.link.field_71573_c);
            ITurtleAccess turtle = null;
            try {
                turtle = ReflectionHelper.getTurtle(te);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!turtle.consumeFuel(Math.abs((int)Math.ceil((double)((xdif + ydif + zdif) * (Math.abs(this.field_145850_b.field_73011_w.field_76574_g - destWorld.field_73011_w.field_76574_g) + 1)) * Config.teleporterPenalty)))) {
                throw new LuaException("Not enough fuel");
            }
            boolean result = turtle.teleportTo((World)destWorld, linkToX, linkToY, linkToZ);
            destWorld.func_147471_g(linkToX, linkToY, linkToZ);
            this.field_145850_b.func_147471_g(this.field_145851_c + Facing.field_71586_b[this.func_145832_p()], this.field_145848_d + Facing.field_71587_c[this.func_145832_p()], this.field_145849_e + Facing.field_71585_d[this.func_145832_p()]);
            destWorld.func_147444_c(linkToX, linkToY, linkToZ, te.field_145854_h);
            this.field_145850_b.func_147444_c(this.field_145851_c + Facing.field_71586_b[this.func_145832_p()], this.field_145848_d + Facing.field_71587_c[this.func_145832_p()], this.field_145849_e + Facing.field_71585_d[this.func_145832_p()], null);
            if (result) {
                // empty if block
            }
            return new Object[]{result};
        }
        if (method == 2) {
            HashMap<Integer, Object> map1 = new HashMap<Integer, Object>();
            for (int i = 0; i < this.links.size(); ++i) {
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                map2.put("dim", ((LinkData)this.links.get((int)i)).linkDim);
                map2.put("x", ((LinkData)this.links.get((int)i)).link.field_71574_a);
                map2.put("y", ((LinkData)this.links.get((int)i)).link.field_71572_b);
                map2.put("z", ((LinkData)this.links.get((int)i)).link.field_71573_c);
                map2.put("name", this.name);
                map1.put(i, map2.clone());
            }
            return new Object[]{map1};
        }
        if (method == 3) {
            if (arguments.length < 1 || !(arguments[0] instanceof String)) {
                throw new LuaException("Bad argument #1 (expected string)");
            }
            this.name = (String)arguments[0];
            return new Object[]{this.name};
        }
        return new Object[0];
    }

    public void onTeleport(byte flag) {
        if (!FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int facing = this.func_145832_p();
            for (int j = 0; j < 32; ++j) {
                this.field_145850_b.func_72869_a("portal", (double)this.field_145851_c + 0.5 + 1.0 * (double)Facing.field_71586_b[facing], (double)this.field_145848_d + 1.0 * (double)Facing.field_71587_c[facing] + this.field_145850_b.field_73012_v.nextDouble() * 2.0, (double)this.field_145849_e + 0.5 + 1.0 * (double)Facing.field_71585_d[this.func_145832_p()], this.field_145850_b.field_73012_v.nextGaussian(), 0.0, this.field_145850_b.field_73012_v.nextGaussian());
            }
        } else {
            String sound = "mob.endermen.portal";
            if (Loader.isModLoaded((String)"Mystcraft")) {
                sound = flag == 1 ? "myst.sound.link-portal" : "myst.sound.link-intra";
            }
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, sound, 1.0f, 1.0f);
        }
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }

    public void blockActivated(EntityPlayer player) {
        ItemStack held = player.func_71045_bC();
        if (held != null && held.func_77969_a(new ItemStack(Items.field_151107_aW))) {
            if (held.field_77990_d != null && held.field_77990_d.func_74764_b("p++LinkX") && held.field_77990_d.func_74764_b("p++LinkY") && held.field_77990_d.func_74764_b("p++LinkZ") && held.field_77990_d.func_74764_b("p++LinkDim")) {
                ChunkCoordinates link = new ChunkCoordinates(held.field_77990_d.func_74762_e("p++LinkX"), held.field_77990_d.func_74762_e("p++LinkY"), held.field_77990_d.func_74762_e("p++LinkZ"));
                int linkDim = held.field_77990_d.func_74762_e("p++LinkDim");
                WorldServer srcWorld = MinecraftServer.func_71276_C().func_71218_a(linkDim);
                if (srcWorld == null) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Link failed: World is missing"));
                } else {
                    TileEntity te = srcWorld.func_147438_o(link.field_71574_a, link.field_71572_b, link.field_71573_c);
                    if (!(te instanceof TileEntityTeleporter)) {
                        player.func_146105_b((IChatComponent)new ChatComponentText("Link failed: Teleporter no longer exists"));
                    } else {
                        TileEntityTeleporter src = (TileEntityTeleporter)te;
                        if (link.field_71574_a == this.field_145851_c && link.field_71572_b == this.field_145848_d && link.field_71573_c == this.field_145849_e) {
                            player.func_146105_b((IChatComponent)new ChatComponentText("Link canceled"));
                        } else {
                            boolean unlinked = false;
                            for (int i = 0; i < src.links.size(); ++i) {
                                LinkData rlink = (LinkData)src.links.get(i);
                                if (rlink.link.field_71574_a != this.field_145851_c || rlink.link.field_71572_b != this.field_145848_d || rlink.link.field_71573_c != this.field_145849_e || rlink.linkDim != this.field_145850_b.field_73011_w.field_76574_g) continue;
                                player.func_146105_b((IChatComponent)new ChatComponentText("Unlinked teleporter at " + rlink.linkDim + ":(" + rlink.link.field_71574_a + "," + rlink.link.field_71572_b + "," + rlink.link.field_71573_c + ") (link " + (i + 1) + ") from this teleporter"));
                                src.links.remove(i);
                                unlinked = true;
                                break;
                            }
                            if (!unlinked) {
                                src.addLink(this.field_145850_b.field_73011_w.field_76574_g, new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                                player.func_146105_b((IChatComponent)new ChatComponentText("Linked teleporter at " + linkDim + ":(" + link.field_71574_a + "," + link.field_71572_b + "," + link.field_71573_c + ") (link " + src.links.size() + ") to this teleporter"));
                            }
                        }
                    }
                }
                held.field_77990_d.func_82580_o("p++LinkX");
                held.field_77990_d.func_82580_o("p++LinkY");
                held.field_77990_d.func_82580_o("p++LinkZ");
                held.field_77990_d.func_82580_o("p++LinkDim");
                if (held.field_77990_d.func_74764_b("display")) {
                    NBTTagCompound display = held.field_77990_d.func_74775_l("display");
                    display.func_82580_o("Lore");
                    if (display.func_82582_d()) {
                        held.field_77990_d.func_82580_o("display");
                    } else {
                        held.field_77990_d.func_74782_a("display", (NBTBase)display);
                    }
                }
                return;
            }
            if (held.field_77990_d == null) {
                held.field_77990_d = new NBTTagCompound();
            }
            held.field_77990_d.func_74768_a("p++LinkX", this.field_145851_c);
            held.field_77990_d.func_74768_a("p++LinkY", this.field_145848_d);
            held.field_77990_d.func_74768_a("p++LinkZ", this.field_145849_e);
            held.field_77990_d.func_74768_a("p++LinkDim", this.field_145850_b.field_73011_w.field_76574_g);
            NBTTagCompound display = new NBTTagCompound();
            NBTTagList lore = new NBTTagList();
            lore.func_74742_a((NBTBase)new NBTTagString("Turtle Teleporter Link"));
            lore.func_74742_a((NBTBase)new NBTTagString(this.field_145850_b.field_73011_w.field_76574_g + ":(" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ")"));
            display.func_74782_a("Lore", (NBTBase)lore);
            held.field_77990_d.func_74782_a("display", (NBTBase)display);
            player.func_146105_b((IChatComponent)new ChatComponentText("Link started"));
        }
    }

    public int addLink(int linkDim, ChunkCoordinates link) {
        this.links.add(new LinkData(linkDim, link));
        while (this.links.size() > this.getMaxLinks()) {
            this.links.pop();
        }
        return this.links.size();
    }

    public static class LinkData {
        public int linkDim;
        public ChunkCoordinates link;

        public LinkData(int linkDim, ChunkCoordinates link) {
            this.linkDim = linkDim;
            this.link = link;
        }
    }
}

