/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.MountedTileEntity;
import com.austinv11.peripheralsplusplus.utils.ChatUtil;
import com.austinv11.peripheralsplusplus.utils.Util;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityOreDictionary
extends MountedTileEntity {
    public static String publicName = "oreDictionary";
    private String name = "tileEntityOreDictionary";
    private HashMap<IComputerAccess, Boolean> computers = new HashMap();
    private ITurtleAccess turtle = null;

    public TileEntityOreDictionary() {
    }

    public TileEntityOreDictionary(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getName() {
        return this.name;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
    }

    public String getType() {
        return publicName;
    }

    private boolean isTurtle() {
        return this.turtle != null;
    }

    public String[] getMethodNames() {
        if (this.isTurtle()) {
            return new String[]{"getEntries", "combineStacks", "transmute", "doItemsMatch"};
        }
        return new String[0];
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableOreDictionary) {
            throw new LuaException("Ore Dictionaries have been disabled");
        }
        try {
            if (method == 0) {
                ItemStack slot = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot());
                return new Object[]{Util.getEntries(slot)};
            }
            if (method == 1) {
                if (arguments.length <= 0 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (arguments.length <= 1 || !(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                double arg1 = (Double)arguments[0];
                double arg2 = (Double)arguments[1];
                ItemStack slot = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot());
                ItemStack stack1 = this.turtle.getInventory().func_70301_a((int)(arg1 -= 1.0));
                ItemStack stack2 = this.turtle.getInventory().func_70301_a((int)(arg2 -= 1.0));
                if (stack1 == null || stack2 == null) {
                    throw new LuaException("One or more selected slots have nil items");
                }
                if (!Util.compare(stack1, stack2)) {
                    return new Object[]{false};
                }
                if (!Util.compare(stack1, slot) && slot != null) {
                    throw new LuaException("The destination slot is incompatible");
                }
                int maxMoveSize = 0;
                int move1 = stack1.field_77994_a;
                int move2 = stack2.field_77994_a;
                maxMoveSize = slot != null ? slot.func_77976_d() - slot.field_77994_a : stack1.func_77976_d() - stack1.field_77994_a;
                if (move1 + move2 > maxMoveSize) {
                    if (move1 >= maxMoveSize) {
                        move1 = maxMoveSize;
                    }
                    move2 = maxMoveSize - move1;
                }
                stack1.field_77994_a -= move1;
                stack2.field_77994_a -= move2;
                if (slot != null) {
                    slot.field_77994_a = move1 + move2;
                    this.turtle.getInventory().func_70299_a(this.turtle.getSelectedSlot(), slot.func_77946_l());
                    if (stack1.field_77994_a <= 0) {
                        this.turtle.getInventory().func_70299_a((int)arg1, null);
                    } else {
                        this.turtle.getInventory().func_70299_a((int)arg1, stack1.func_77946_l());
                    }
                    if (stack2.field_77994_a <= 0) {
                        this.turtle.getInventory().func_70299_a((int)arg2, null);
                    } else {
                        this.turtle.getInventory().func_70299_a((int)arg2, stack2.func_77946_l());
                    }
                } else {
                    ItemStack newStack = new ItemStack(stack1.func_77973_b());
                    newStack.field_77994_a = move1 + move2;
                    this.turtle.getInventory().func_70299_a(this.turtle.getSelectedSlot(), newStack.func_77946_l());
                    if (stack1.field_77994_a <= 0) {
                        this.turtle.getInventory().func_70299_a((int)arg1, null);
                    } else {
                        this.turtle.getInventory().func_70299_a((int)arg1, stack1.func_77946_l());
                    }
                    if (stack2.field_77994_a <= 0) {
                        this.turtle.getInventory().func_70299_a((int)arg2, null);
                    } else {
                        this.turtle.getInventory().func_70299_a((int)arg2, stack2.func_77946_l());
                    }
                }
                return new Object[]{true};
            }
            if (method == 2) {
                ItemStack slot = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot());
                if (slot == null) {
                    throw new LuaException("Selected slot's item is nil");
                }
                ItemStack newStack = this.transmute(slot);
                if (newStack == null || newStack.func_77969_a(slot)) {
                    return new Object[]{false};
                }
                newStack.field_77994_a = slot.field_77994_a;
                this.turtle.getInventory().func_70299_a(this.turtle.getSelectedSlot(), newStack);
                return new Object[]{true};
            }
            if (method == 3) {
                if (arguments.length <= 0 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (arguments.length <= 1 || !(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                double arg1 = (Double)arguments[0];
                double arg2 = (Double)arguments[1];
                return new Object[]{Util.compare(this.turtle.getInventory().func_70301_a((int)(arg1 -= 1.0)), this.turtle.getInventory().func_70301_a((int)(arg2 -= 1.0)))};
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Object[0];
    }

    @Override
    public void attach(IComputerAccess computer) {
        if (!this.isTurtle()) {
            this.computers.put(computer, true);
        }
        super.attach(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        if (!this.isTurtle()) {
            this.computers.remove(computer);
        }
        super.detach(computer);
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }

    private ItemStack transmute(ItemStack item) {
        HashMap<Integer, String> entries = Util.getEntries(item);
        int i = 0;
        boolean test = false;
        for (String v : entries.values()) {
            for (ItemStack stack : OreDictionary.getOres((String)v)) {
                if (test) {
                    return stack.func_77946_l();
                }
                if (stack.func_77969_a(item)) {
                    test = true;
                }
                ++i;
            }
            if (test) {
                return ((ItemStack)OreDictionary.getOres((String)v).get(0)).func_77946_l();
            }
            i = 0;
        }
        return null;
    }

    public void blockActivated(EntityPlayer player) {
        if (player.func_70694_bm() != null) {
            for (IComputerAccess computer : this.computers.keySet()) {
                computer.queueEvent("oreDict", new Object[]{Util.getEntries(player.func_70694_bm())});
            }
            if (Config.oreDictionaryMessage) {
                ChatUtil.sendMessage(player.getDisplayName(), this, Util.getEntries(player.func_70694_bm()).entrySet().toString(), 100.0, true);
            }
        }
    }
}

