/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.collectiveframework.minecraft.utils.Location;
import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.network.ParticlePacket;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.MountedTileEntity;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class TileEntityNoteBlock
extends MountedTileEntity {
    private static final int MAX_NOTES = 24;
    private static final int MAX_NOTES_TICK = 5;
    public static final String publicName = "noteBlock";
    private ITurtleAccess turtle;
    private Location location;
    private int tick = 0;
    private final String[] instruments = new String[]{"harp", "bd", "snare", "hat", "bassattack"};

    public TileEntityNoteBlock() {
        this.location = new Location((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.func_145831_w());
    }

    public TileEntityNoteBlock(ITurtleAccess turtle) {
        this.location = new Location((double)turtle.getPosition().field_71574_a, (double)turtle.getPosition().field_71572_b, (double)turtle.getPosition().field_71573_c, turtle.getWorld());
        this.field_145851_c = (int)this.location.getX();
        this.field_145848_d = (int)this.location.getY();
        this.field_145849_e = (int)this.location.getZ();
        this.func_145834_a(this.location.getWorld());
        this.turtle = turtle;
    }

    public String getType() {
        return publicName;
    }

    public String[] getMethodNames() {
        return new String[]{"playNote", "playSound"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableNoteBlock) {
            throw new LuaException("Iron Note Blocks have been disabled");
        }
        switch (method) {
            case 0: {
                this.checkPlayNote(arguments);
                break;
            }
            case 1: {
                this.checkPlaySound(arguments);
            }
        }
        return new Object[0];
    }

    private void checkPlaySound(Object[] arguments) throws LuaException {
        if (arguments.length < 1) {
            throw new LuaException("Expected at least 1 argument");
        }
        if (!(arguments[0] instanceof String)) {
            throw new LuaException("First argument expected to be a string");
        }
        if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
            throw new LuaException("Second argument expected to be a number");
        }
        if (arguments.length > 2 && !(arguments[2] instanceof Double)) {
            throw new LuaException("Third argument expected to be a number");
        }
        String sound = (String)arguments[0];
        double volume = arguments.length > 1 ? (Double)arguments[1] : 1.0;
        double pitch = arguments.length > 2 ? (Double)arguments[1] : 1.0;
        this.location.getWorld().func_72908_a(this.location.getX() + 0.5, this.location.getY() + 0.5, this.location.getZ() + 0.5, sound, (float)volume, (float)pitch);
    }

    private void checkPlayNote(Object[] arguments) throws LuaException {
        if (arguments.length < 2) {
            throw new LuaException("Expected 2 arguments");
        }
        if (!(arguments[0] instanceof Double)) {
            throw new LuaException("First argument expected to be a number");
        }
        if (!(arguments[1] instanceof Double)) {
            throw new LuaException("Second argument expected to be a number");
        }
        int instrument = ((Double)arguments[0]).intValue();
        if (instrument < 0 || instrument >= this.instruments.length) {
            throw new LuaException("Invalid instrument");
        }
        int note = ((Double)arguments[1]).intValue();
        if (note < 0 || note > 24) {
            throw new LuaException("Invalid note");
        }
        if (++this.tick > 5) {
            throw new LuaException("More than 5 note plays called per tick");
        }
        ChunkCoordinates position = this.location.toChunkCoordinates();
        World world = this.location.getWorld();
        if (position == null || world == null) {
            return;
        }
        this.playNote(world, this.location.getX(), this.location.getY(), this.location.getZ(), instrument, note);
        PeripheralsPlusPlus.NETWORK.sendToAllAround((IMessage)new ParticlePacket("note", this.location.getX() + 0.5, this.location.getY() + 1.2, this.location.getZ() + 0.5, (double)note / 24.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, this.location.getX(), this.location.getY(), this.location.getZ(), Config.noteBlockRange));
    }

    private void playNote(World world, double x, double y, double z, int instrument, int note) {
        float inflate = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
        String instrumentName = this.instruments[instrument];
        world.func_72908_a(x + 0.5, y + 0.5, z + 0.5, "note." + instrumentName, 3.0f, inflate);
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.tick = 0;
    }

    public void updateEntity(boolean turtle) {
        if (turtle) {
            this.location = new Location((double)this.turtle.getPosition().field_71574_a, (double)this.turtle.getPosition().field_71572_b, (double)this.turtle.getPosition().field_71573_c, this.turtle.getWorld());
            this.field_145851_c = (int)this.location.getX();
            this.field_145848_d = (int)this.location.getY();
            this.field_145849_e = (int)this.location.getZ();
        }
        this.func_145845_h();
    }

    @Override
    public void attach(IComputerAccess computer) {
        super.attach(computer);
        this.location = new Location((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.func_145831_w());
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }
}

