/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.items.ItemSmartHelmet;
import com.austinv11.peripheralsplusplus.lua.LuaObjectEntityControl;
import com.austinv11.peripheralsplusplus.lua.LuaObjectHUD;
import com.austinv11.peripheralsplusplus.network.ScaleRequestPacket;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.MountedTileEntity;
import com.austinv11.peripheralsplusplus.utils.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class TileEntityAntenna
extends MountedTileEntity {
    public static String publicName = "antenna";
    private String name = "tileEntityAntenna";
    private int world = 0;
    public HashMap<IComputerAccess, Boolean> computers = new HashMap();
    private HashMap<Integer, LuaObjectHUD> huds = new HashMap();
    public static HashMap<UUID, TileEntityAntenna> antenna_registry = new HashMap();
    public UUID identifier;
    public String label;
    public volatile List<Entity> associatedEntities = new ArrayList<Entity>();

    public TileEntityAntenna() {
        this.identifier = UUID.randomUUID();
        while (antenna_registry.containsKey(this.identifier) && !antenna_registry.get(this.identifier).equals(this)) {
            this.identifier = UUID.randomUUID();
        }
    }

    public String getName() {
        return this.name;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("identifier")) {
            this.identifier = UUID.fromString(nbttagcompound.func_74779_i("identifier"));
        }
        if (nbttagcompound.func_74764_b("label")) {
            this.label = nbttagcompound.func_74779_i("label");
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74778_a("identifier", this.identifier.toString());
        if (this.label != null) {
            nbttagcompound.func_74778_a("label", this.label);
        }
    }

    public String getType() {
        return publicName;
    }

    public String[] getMethodNames() {
        return new String[]{"getPlayers", "getHUD", "setLabel", "getLabel", "getInfectedEntities", "getInfectedEntity"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableSmartHelmet && method < 6) {
            throw new LuaException("Smart Helmets have been disabled");
        }
        if (!Config.enableNanoBots) {
            throw new LuaException("Nano bots have been disabled");
        }
        switch (method) {
            case 0: {
                TileEntityAntenna tileEntityAntenna = this;
                synchronized (tileEntityAntenna) {
                    ArrayList<String> players = new ArrayList<String>();
                    for (Object player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                        if (!(player instanceof EntityPlayer) || ((EntityPlayer)player).func_82169_q(3) == null || !(((EntityPlayer)player).func_82169_q(3).func_77973_b() instanceof ItemSmartHelmet) || !NBTHelper.hasTag((ItemStack)((EntityPlayer)player).func_82169_q(3), (String)"identifier") || !this.identifier.equals(UUID.fromString(NBTHelper.getString((ItemStack)((EntityPlayer)player).func_82169_q(3), (String)"identifier")))) continue;
                        players.add(((EntityPlayer)player).func_70005_c_());
                    }
                    return new Object[]{Util.arrayToMap(players.toArray())};
                }
            }
            case 1: {
                TileEntityAntenna tileEntityAntenna = this;
                synchronized (tileEntityAntenna) {
                    if (arguments.length < 1) {
                        throw new LuaException("Not enough arguments");
                    }
                    if (!(arguments[0] instanceof String)) {
                        throw new LuaException("Bad argument #1 (expected string)");
                    }
                    if (Util.getPlayer((String)arguments[0]) == null) {
                        return new Object[]{null};
                    }
                    LuaObjectHUD obj = new LuaObjectHUD((String)arguments[0], this.identifier);
                    this.huds.put(computer.getID(), obj);
                    PeripheralsPlusPlus.NETWORK.sendTo((IMessage)new ScaleRequestPacket(this, computer.getID(), this.world), (EntityPlayerMP)Util.getPlayer((String)arguments[0]));
                    context.pullEvent("resolution");
                    return new Object[]{obj};
                }
            }
            case 2: {
                TileEntityAntenna tileEntityAntenna = this;
                synchronized (tileEntityAntenna) {
                    if (arguments.length != 1) {
                        throw new LuaException("Incorrect Arguments!");
                    }
                    this.setLabel(arguments[0].toString());
                }
            }
            case 3: {
                TileEntityAntenna tileEntityAntenna = this;
                synchronized (tileEntityAntenna) {
                    return new Object[]{this.getLabel()};
                }
            }
            case 4: {
                HashMap<Integer, Integer> entities = new HashMap<Integer, Integer>();
                for (int i = 0; i < this.associatedEntities.size(); ++i) {
                    entities.put(i + 1, this.associatedEntities.get(i).func_145782_y());
                }
                return new Object[]{entities};
            }
            case 5: {
                if (arguments.length < 1) {
                    throw new LuaException("Too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                Entity ent = this.entityFromId((int)((Double)arguments[0]).doubleValue());
                if (ent != null) {
                    return new Object[]{new LuaObjectEntityControl(this.identifier, ent)};
                }
                throw new LuaException("Entity with id " + arguments[0] + " not found");
            }
        }
        return new Object[0];
    }

    private Entity entityFromId(int id) {
        for (Entity entity : this.associatedEntities) {
            if (entity.func_145782_y() != id) continue;
            return entity;
        }
        return null;
    }

    public void func_145845_h() {
        if (this.field_145850_b != null) {
            this.world = this.field_145850_b.field_73011_w.field_76574_g;
            if (!antenna_registry.containsKey(this.identifier)) {
                antenna_registry.put(this.identifier, this);
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        antenna_registry.remove(this.identifier);
    }

    public void func_145829_t() {
        super.func_145829_t();
        antenna_registry.put(this.identifier, this);
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.computers.put(computer, true);
        super.attach(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
        super.detach(computer);
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public void onResponse(int id, int width, int height) {
        if (this.huds.containsKey(id)) {
            this.huds.get((Object)Integer.valueOf((int)id)).height = height;
            this.huds.get((Object)Integer.valueOf((int)id)).width = width;
            for (IComputerAccess comp : this.computers.keySet()) {
                if (comp.getID() != id) continue;
                comp.queueEvent("resolution", new Object[]{height, width});
            }
        }
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    public String getLabel() {
        return this.label;
    }
}

