/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.pocket.peripherals;

import com.austinv11.collectiveframework.minecraft.utils.Location;
import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.turtles.peripherals.MountedPeripheral;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class PeripheralMotionDetector
extends MountedPeripheral {
    private Location oldLocation = null;
    private IComputerAccess computer;
    private float pitch;
    private float yaw;

    public PeripheralMotionDetector(Entity entity) {
        if (entity != null) {
            this.oldLocation = new Location(entity);
            this.setPitchAndYaw(entity);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setPitchAndYaw(Entity entity) {
        this.pitch = entity.field_70125_A;
        this.yaw = entity.field_70177_z;
    }

    public String getType() {
        return "motionDetector";
    }

    public String[] getMethodNames() {
        return new String[0];
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }

    public void update(Entity entity) {
        if (!Config.enableMotionDetector) {
            return;
        }
        if (this.computer != null) {
            Location newLocation = new Location(entity);
            if (this.oldLocation == null) {
                this.oldLocation = new Location(newLocation);
            }
            if (!newLocation.equals((Object)this.oldLocation)) {
                if (!newLocation.getWorld().equals(this.oldLocation.getWorld())) {
                    this.computer.queueEvent("worldChanged", new Object[]{this.oldLocation.getWorld().field_73011_w.field_76574_g, newLocation.getWorld().field_73011_w.field_76574_g});
                }
                this.computer.queueEvent("locationChanged", new Object[]{newLocation.getX() - this.oldLocation.getX(), newLocation.getY() - this.oldLocation.getY(), newLocation.getZ() - this.oldLocation.getZ()});
                this.oldLocation = newLocation;
            }
            if (entity.field_70125_A != this.pitch || entity.field_70177_z != this.yaw) {
                this.computer.queueEvent("rotationChanged", new Object[]{Float.valueOf(entity.field_70177_z), Float.valueOf(entity.field_70125_A)});
                this.setPitchAndYaw(entity);
            }
        }
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.computer = computer;
        super.attach(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computer = null;
        super.detach(computer);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!Config.enableMotionDetector) {
            return;
        }
        if (this.computer == null) {
            return;
        }
        if (!event.isCanceled() && event.entityPlayer.func_71045_bC() != null && event.entityPlayer.func_71045_bC().func_77973_b() instanceof ItemPocketComputer && NBTHelper.hasTag((ItemStack)event.entityPlayer.func_71045_bC(), (String)"upgrade")) {
            int upgrade = -1;
            if (NBTHelper.hasTag((ItemStack)event.entityPlayer.func_71045_bC(), (String)"upgrades")) {
                NBTTagList list = NBTHelper.getList((ItemStack)event.entityPlayer.func_71045_bC(), (String)"upgrades", (int)5);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    if ((int)list.func_150308_e(i) != 2) continue;
                    upgrade = (int)list.func_150308_e(i);
                    break;
                }
            } else {
                upgrade = NBTHelper.getShort((ItemStack)event.entityPlayer.func_71045_bC(), (String)"upgrade");
            }
            if (upgrade == 2) {
                if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
                    this.computer.queueEvent("blockHit", new Object[0]);
                } else {
                    this.computer.queueEvent("rightClick", new Object[0]);
                }
            }
        }
    }
}

