/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.pocket;

import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.collectiveframework.utils.LogicUtils;
import com.austinv11.peripheralsplusplus.hooks.ComputerCraftHooks;
import com.austinv11.peripheralsplusplus.hooks.ComputerCraftRegistry;
import com.austinv11.peripheralsplusplus.hooks.IPocketComputerUpgrade;
import com.austinv11.peripheralsplusplus.init.ModBlocks;
import com.austinv11.peripheralsplusplus.pocket.peripherals.PeripheralPeripheralContainer;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class PocketPeripheralContainer
implements IPocketComputerUpgrade {
    @Override
    public int getUpgradeID() {
        return 3;
    }

    @Override
    public String getUnlocalisedAdjective() {
        return "peripheralsplusplus.pocketUpgrade.peripheralContainer";
    }

    @Override
    public ItemStack getCraftingItem() {
        return new ItemStack((Block)ModBlocks.peripheralContainer);
    }

    @Override
    public IPeripheral createPeripheral(Entity entity, ItemStack stack) {
        return new PeripheralPeripheralContainer(stack);
    }

    @Override
    public void update(Entity entity, ItemStack stack, IPeripheral peripheral) {
        int id = NBTHelper.getInt((ItemStack)stack, (String)"computerID");
        if (NBTHelper.hasTag((ItemStack)stack, (String)"upgrades")) {
            List<IPocketComputerUpgrade> upgrades = this.getUpgrades(stack);
            HashMap<Integer, IPeripheral> peripherals = ComputerCraftHooks.cachedExtraPeripherals.get(id);
            for (IPocketComputerUpgrade upgrade : upgrades) {
                if (!peripherals.containsKey(upgrade.getUpgradeID())) continue;
                upgrade.update(entity, stack, peripherals.get(upgrade.getUpgradeID()));
            }
        }
    }

    @Override
    public boolean onRightClick(World world, EntityPlayer player, ItemStack stack, IPeripheral peripheral) {
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        List<IPocketComputerUpgrade> upgrades = this.getUpgrades(stack);
        for (IPocketComputerUpgrade upgrade : upgrades) {
            results.add(upgrade.onRightClick(world, player, stack, peripheral));
        }
        boolean[] boolArray = new boolean[results.size()];
        for (int i = 0; i < results.size(); ++i) {
            boolArray[i] = (Boolean)results.get(i);
        }
        return LogicUtils.or((boolean[])boolArray);
    }

    public List<IPocketComputerUpgrade> getUpgrades(ItemStack item) {
        ArrayList<IPocketComputerUpgrade> upgrades = new ArrayList<IPocketComputerUpgrade>();
        if (NBTHelper.hasTag((ItemStack)item, (String)"upgrades")) {
            NBTTagList list = NBTHelper.getList((ItemStack)item, (String)"upgrades", (int)5);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                int id = (int)list.func_150308_e(i);
                upgrades.add(ComputerCraftRegistry.pocketUpgrades.get(id));
            }
        }
        return upgrades;
    }
}

