/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.mount;

import com.austinv11.collectiveframework.multithreading.SimpleRunnable;
import com.austinv11.collectiveframework.utils.WebUtils;
import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.tiles.TileEntityAnalyzer;
import com.austinv11.peripheralsplusplus.utils.JSONFileList;
import com.austinv11.peripheralsplusplus.utils.JSONIndex;
import com.austinv11.peripheralsplusplus.utils.Util;
import com.google.gson.Gson;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class DynamicMount
implements IMount {
    public static final String MOUNT_DIRECTORY = PeripheralsPlusPlus.BASE_PPP_DIR + "ppp_mount";
    public static final String DIRECTORY = "/ppp";
    public static final String JSON_VER = "1.1";
    private IPeripheral peripheral;

    public DynamicMount(IPeripheral peripheral) {
        this.peripheral = peripheral;
    }

    public static void prepareMount() {
        new SimpleRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Gson gson = new Gson();
                    JSONIndex index = (JSONIndex)gson.fromJson(Util.listToString(WebUtils.readGithub((String)"PeripheralsPlusPlus", (String)"lua/index.json")), JSONIndex.class);
                    if (!index.ver.equals(DynamicMount.JSON_VER)) {
                        PeripheralsPlusPlus.LOGGER.warn((Object)"JSON Version mismatch! Is your version of Peripherals++ outdated?");
                    }
                    String[] dirs = index.dirs;
                    PeripheralsPlusPlus.LOGGER.info((Object)(dirs.length + " directories found! Attempting to update (if necessary)..."));
                    for (String d : dirs) {
                        String[] files1;
                        JSONFileList files = (JSONFileList)gson.fromJson(Util.listToString(WebUtils.readGithub((String)"PeripheralsPlusPlus", (String)("lua/" + d + "/index.json"))), JSONFileList.class);
                        if (!Util.checkFileVersion(MOUNT_DIRECTORY + "/" + d, files)) continue;
                        for (String f : files1 = files.files) {
                            File file = new File((MOUNT_DIRECTORY + "/" + d + "/" + f).replace(".lua", ""));
                            file.mkdirs();
                            file.delete();
                            file.createNewFile();
                            FileWriter writer = new FileWriter(file);
                            writer.write(Util.listToString(WebUtils.readGithub((String)"PeripheralsPlusPlus", (String)("lua/" + d + "/" + f))));
                            writer.close();
                        }
                    }
                    PeripheralsPlusPlus.LOGGER.info((Object)"Mount has been successfully prepared!");
                }
                catch (Exception e) {
                    PeripheralsPlusPlus.LOGGER.error((Object)"An exception was thrown attempting to prepare mount programs; if your internet connection is fine, please report the following to the mod author:");
                    e.printStackTrace();
                }
                finally {
                    this.disable(true);
                }
            }

            public String getName() {
                return "Dynamic Mount Update Thread";
            }
        }.start();
    }

    public boolean exists(String path) throws IOException {
        return new File(MOUNT_DIRECTORY + "/" + path).exists();
    }

    public boolean isDirectory(String path) throws IOException {
        return new File(MOUNT_DIRECTORY + "/" + path).isDirectory();
    }

    public void list(String path, List<String> contents) throws IOException {
        File file = new File(MOUNT_DIRECTORY + "/" + path);
        for (File f : file.listFiles()) {
            String type = this.getSafeType();
            if (!f.getName().equals(type) && !file.getAbsolutePath().contains(type) || path.contains("index")) continue;
            contents.add(f.getName());
        }
    }

    public long getSize(String path) throws IOException {
        return new File(MOUNT_DIRECTORY + "/" + path).getTotalSpace();
    }

    public InputStream openForRead(String path) throws IOException {
        return new FileInputStream(new File(MOUNT_DIRECTORY + "/" + path));
    }

    private String getSafeType() {
        return this.peripheral instanceof TileEntityAnalyzer ? "analyzers" : this.peripheral.getType();
    }
}

