/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.lua;

import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.network.CommandPacket;
import com.austinv11.peripheralsplusplus.network.GuiPacket;
import com.austinv11.peripheralsplusplus.smarthelmet.AddButtonCommand;
import com.austinv11.peripheralsplusplus.smarthelmet.AddTextFieldCommand;
import com.austinv11.peripheralsplusplus.smarthelmet.DrawBackgroundCommand;
import com.austinv11.peripheralsplusplus.smarthelmet.DrawRectangleCommand;
import com.austinv11.peripheralsplusplus.smarthelmet.DrawStringCommand;
import com.austinv11.peripheralsplusplus.smarthelmet.DrawTextureCommand;
import com.austinv11.peripheralsplusplus.smarthelmet.HelmetCommand;
import com.austinv11.peripheralsplusplus.smarthelmet.MessageCommand;
import com.austinv11.peripheralsplusplus.utils.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class LuaObjectHUD
implements ILuaObject {
    public ArrayDeque<HelmetCommand> renderStack = new ArrayDeque();
    private EntityPlayer player;
    public int width = -1;
    public int height = -1;
    private UUID uuid;
    private boolean isGui = false;
    public MessageCommand messageCommand = new MessageCommand();

    public LuaObjectHUD(String player, UUID uuid) {
        this.player = Util.getPlayer(player);
        this.uuid = uuid;
        if (!MessageCommand.messageStacks.containsKey(player)) {
            MessageCommand.messageStacks.put(player, new Stack());
        }
        this.messageCommand.player = player;
        this.renderStack.add(this.messageCommand);
    }

    public LuaObjectHUD(String player, UUID uuid, boolean isGui) {
        this(player, uuid);
        this.isGui = isGui;
    }

    public String[] getMethodNames() {
        String[] stringArray;
        if (this.isGui) {
            String[] stringArray2 = new String[16];
            stringArray2[0] = "getResolution";
            stringArray2[1] = "sendMessage";
            stringArray2[2] = "drawString";
            stringArray2[3] = "drawTexture";
            stringArray2[4] = "drawRectangle";
            stringArray2[5] = "drawHorizontalLine";
            stringArray2[6] = "drawVerticalLine";
            stringArray2[7] = "getColorFromRGB";
            stringArray2[8] = "sync";
            stringArray2[9] = "clear";
            stringArray2[10] = "add";
            stringArray2[11] = "open";
            stringArray2[12] = "close";
            stringArray2[13] = "drawBackground";
            stringArray2[14] = "addButton";
            stringArray = stringArray2;
            stringArray2[15] = "addTextField";
        } else {
            String[] stringArray3 = new String[12];
            stringArray3[0] = "getResolution";
            stringArray3[1] = "sendMessage";
            stringArray3[2] = "drawString";
            stringArray3[3] = "drawTexture";
            stringArray3[4] = "drawRectangle";
            stringArray3[5] = "drawHorizontalLine";
            stringArray3[6] = "drawVerticalLine";
            stringArray3[7] = "getColorFromRGB";
            stringArray3[8] = "sync";
            stringArray3[9] = "clear";
            stringArray3[10] = "add";
            stringArray = stringArray3;
            stringArray3[11] = "getGUI";
        }
        return stringArray;
    }

    public Object[] callMethod(ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.width, this.height};
            }
            case 1: {
                if (arguments.length < 1) {
                    throw new LuaException("Not enough arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new LuaException("Bad argument #1 (expected string)");
                }
                MessageCommand.messageStacks.get(this.player.getDisplayName()).push((String)arguments[0]);
                break;
            }
            case 2: {
                if (arguments.length < 3) {
                    throw new LuaException("Not enough arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new LuaException("Bad argument #1 (expected string)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                if (!(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected number)");
                }
                if (arguments.length > 3 && !(arguments[3] instanceof Double)) {
                    throw new LuaException("Bad argument #4 (expected number)");
                }
                if (arguments.length > 4 && !(arguments[4] instanceof Boolean)) {
                    throw new LuaException("Bad argument #5 (expected boolean)");
                }
                int color = Color.WHITE.getRGB();
                if (arguments.length > 3) {
                    color = (int)((Double)arguments[3]).doubleValue();
                }
                boolean shadow = true;
                if (arguments.length > 4) {
                    shadow = (Boolean)arguments[4];
                }
                DrawStringCommand drawString = new DrawStringCommand();
                drawString.message = (String)arguments[0];
                drawString.x = (int)((Double)arguments[1]).doubleValue();
                drawString.y = (int)((Double)arguments[2]).doubleValue();
                drawString.color = color;
                drawString.shadow = shadow;
                this.renderStack.add(drawString);
                break;
            }
            case 3: {
                if (arguments.length < 3) {
                    throw new LuaException("Not enough arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new LuaException("Bad argument #1 (expected string)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                if (!(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected number)");
                }
                if (arguments.length > 3 && !(arguments[3] instanceof Double)) {
                    throw new LuaException("Bad argument #4 (expected number)");
                }
                if (arguments.length > 4 && !(arguments[4] instanceof Double)) {
                    throw new LuaException("Bad argument #5 (expected number)");
                }
                if (arguments.length > 5 && !(arguments[5] instanceof Double)) {
                    throw new LuaException("Bad argument #6 (expected number)");
                }
                if (arguments.length > 6 && !(arguments[6] instanceof Double)) {
                    throw new LuaException("Bad argument #7 (expected number)");
                }
                int u = -1;
                int v = -1;
                int width = 256;
                int height = 256;
                if (arguments.length > 3) {
                    width = (int)((Double)arguments[3]).doubleValue();
                }
                if (arguments.length > 4) {
                    height = (int)((Double)arguments[4]).doubleValue();
                }
                if (arguments.length > 5) {
                    u = (int)((Double)arguments[5]).doubleValue();
                }
                if (arguments.length > 36) {
                    v = (int)((Double)arguments[6]).doubleValue();
                }
                DrawTextureCommand command = new DrawTextureCommand();
                command.resource = (String)arguments[0];
                command.x = (int)((Double)arguments[1]).doubleValue();
                command.y = (int)((Double)arguments[2]).doubleValue();
                command.u = u;
                command.v = v;
                command.width = width;
                command.height = height;
                this.renderStack.add(command);
                break;
            }
            case 4: {
                if (arguments.length < 5) {
                    throw new LuaException("Not enough arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                if (!(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected number)");
                }
                if (!(arguments[3] instanceof Double)) {
                    throw new LuaException("Bad argument #4 (expected number)");
                }
                if (!(arguments[4] instanceof Double)) {
                    throw new LuaException("Bad argument #5 (expected number)");
                }
                if (arguments.length > 5 && !(arguments[5] instanceof Double)) {
                    throw new LuaException("Bad argument #6 (expected number)");
                }
                DrawRectangleCommand c = new DrawRectangleCommand();
                c.x1 = (int)((Double)arguments[0]).doubleValue();
                c.y1 = (int)((Double)arguments[1]).doubleValue();
                c.x2 = (int)((Double)arguments[2]).doubleValue();
                c.y2 = (int)((Double)arguments[3]).doubleValue();
                c.color = new Color((int)((Double)arguments[4]).doubleValue(), true);
                if (arguments.length > 5) {
                    c.color2 = new Color((int)((Double)arguments[5]).doubleValue(), true);
                }
                this.renderStack.add(c);
                break;
            }
            case 5: {
                if (arguments.length < 4) {
                    throw new LuaException("Not enough arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                if (!(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected number)");
                }
                if (!(arguments[3] instanceof Double)) {
                    throw new LuaException("Bad argument #4 (expected number)");
                }
                DrawRectangleCommand c_ = new DrawRectangleCommand();
                c_.x1 = (int)((Double)arguments[0]).doubleValue();
                c_.y1 = (int)((Double)arguments[1]).doubleValue();
                c_.x2 = (int)((Double)arguments[2]).doubleValue() + 1;
                c_.y2 = c_.y1 + 1;
                c_.color = new Color((int)((Double)arguments[3]).doubleValue(), true);
                this.renderStack.add(c_);
                break;
            }
            case 6: {
                if (arguments.length < 4) {
                    throw new LuaException("Not enough arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                if (!(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected number)");
                }
                if (!(arguments[3] instanceof Double)) {
                    throw new LuaException("Bad argument #4 (expected number)");
                }
                DrawRectangleCommand c1 = new DrawRectangleCommand();
                c1.x1 = (int)((Double)arguments[0]).doubleValue();
                c1.y1 = (int)((Double)arguments[1]).doubleValue() + 1;
                c1.x2 = c1.x1 + 1;
                c1.y2 = (int)((Double)arguments[2]).doubleValue();
                c1.color = new Color((int)((Double)arguments[3]).doubleValue(), true);
                this.renderStack.add(c1);
                break;
            }
            case 7: {
                if (arguments.length < 3) {
                    throw new LuaException("Not enough arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                if (!(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected number)");
                }
                if (arguments.length > 3 && !(arguments[3] instanceof Double)) {
                    throw new LuaException("Bad argument #4 (expected number)");
                }
                if (arguments.length > 3) {
                    return new Object[]{new Color((int)((Double)arguments[0]).doubleValue(), (int)((Double)arguments[1]).doubleValue(), (int)((Double)arguments[2]).doubleValue(), (int)((Double)arguments[3]).doubleValue()).getRGB()};
                }
                return new Object[]{new Color((int)((Double)arguments[0]).doubleValue(), (int)((Double)arguments[1]).doubleValue(), (int)((Double)arguments[2]).doubleValue()).getRGB()};
            }
            case 8: {
                PeripheralsPlusPlus.NETWORK.sendTo((IMessage)new CommandPacket(this.stackToArray(), this.uuid, false, this.isGui), (EntityPlayerMP)this.player);
                MessageCommand.messageStacks.get(this.player.getDisplayName()).clear();
                this.renderStack.clear();
                this.renderStack.add(this.messageCommand);
                break;
            }
            case 9: {
                PeripheralsPlusPlus.NETWORK.sendTo((IMessage)new CommandPacket(new HelmetCommand[0], this.uuid, false, this.isGui), (EntityPlayerMP)this.player);
                MessageCommand.messageStacks.get(this.player.getDisplayName()).clear();
                this.renderStack.clear();
                this.renderStack.add(this.messageCommand);
                break;
            }
            case 10: {
                PeripheralsPlusPlus.NETWORK.sendTo((IMessage)new CommandPacket(this.stackToArray(), this.uuid, true, this.isGui), (EntityPlayerMP)this.player);
                MessageCommand.messageStacks.get(this.player.getDisplayName()).clear();
                this.renderStack.clear();
                this.renderStack.add(this.messageCommand);
                break;
            }
            case 11: {
                if (this.isGui) {
                    PeripheralsPlusPlus.NETWORK.sendTo((IMessage)new GuiPacket(false), (EntityPlayerMP)this.player);
                    break;
                }
                return new Object[]{new LuaObjectHUD(this.player.getDisplayName(), this.uuid, true)};
            }
            case 12: {
                PeripheralsPlusPlus.NETWORK.sendTo((IMessage)new GuiPacket(true), (EntityPlayerMP)this.player);
                break;
            }
            case 13: {
                if (arguments.length > 0 && !(arguments[0] instanceof Boolean)) {
                    throw new LuaException("Bad argument #1 (expected boolean)");
                }
                if (arguments.length > 0) {
                    DrawBackgroundCommand background = new DrawBackgroundCommand();
                    background.defaultBackground = (Boolean)arguments[0];
                    this.renderStack.add(background);
                    break;
                }
                this.renderStack.add(new DrawBackgroundCommand());
                break;
            }
            case 14: {
                if (arguments.length < 6) {
                    throw new LuaException("Not enough arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                if (!(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected number)");
                }
                if (!(arguments[3] instanceof Double)) {
                    throw new LuaException("Bad argument #4 (expected number)");
                }
                if (!(arguments[4] instanceof Double)) {
                    throw new LuaException("Bad argument #5 (expected number)");
                }
                if (!(arguments[5] instanceof String)) {
                    throw new LuaException("Bad argument #6 (expected string)");
                }
                AddButtonCommand addButtonCommand = new AddButtonCommand();
                addButtonCommand.id = (int)((Double)arguments[0]).doubleValue();
                addButtonCommand.x = (int)((Double)arguments[1]).doubleValue();
                addButtonCommand.y = (int)((Double)arguments[2]).doubleValue();
                addButtonCommand.width = (int)((Double)arguments[3]).doubleValue();
                addButtonCommand.height = (int)((Double)arguments[4]).doubleValue();
                addButtonCommand.message = (String)arguments[5];
                this.renderStack.add(addButtonCommand);
                break;
            }
            case 15: {
                if (arguments.length < 5) {
                    throw new LuaException("Not enough arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                if (!(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected number)");
                }
                if (!(arguments[3] instanceof Double)) {
                    throw new LuaException("Bad argument #4 (expected number)");
                }
                if (!(arguments[4] instanceof Double)) {
                    throw new LuaException("Bad argument #5 (expected number)");
                }
                if (arguments.length > 6 && !(arguments[5] instanceof String)) {
                    throw new LuaException("Bad argument #6 (expected string)");
                }
                AddTextFieldCommand addTextFieldCommand = new AddTextFieldCommand();
                addTextFieldCommand.id = (int)((Double)arguments[0]).doubleValue();
                addTextFieldCommand.x = (int)((Double)arguments[1]).doubleValue();
                addTextFieldCommand.y = (int)((Double)arguments[2]).doubleValue();
                addTextFieldCommand.width = (int)((Double)arguments[3]).doubleValue();
                addTextFieldCommand.height = (int)((Double)arguments[4]).doubleValue();
                if (arguments.length > 5) {
                    addTextFieldCommand.message = (String)arguments[5];
                }
                this.renderStack.add(addTextFieldCommand);
            }
        }
        return new Object[0];
    }

    private HelmetCommand[] stackToArray() {
        HelmetCommand[] array = new HelmetCommand[this.renderStack.size()];
        int i = 0;
        while (!this.renderStack.isEmpty()) {
            array[i] = this.renderStack.poll();
            ++i;
        }
        return array;
    }
}

