/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.hooks;

import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.hooks.ComputerCraftRegistry;
import com.austinv11.peripheralsplusplus.pocket.PocketPeripheralContainer;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ComputerCraftHooks {
    public static HashMap<Integer, IPeripheral> cachedPeripherals = new HashMap();
    public static HashMap<Integer, HashMap<Integer, IPeripheral>> cachedExtraPeripherals = new HashMap();

    public static void onPocketComputerCreate(ServerComputer computer, ItemStack stack, IInventory inventory) {
        short upgrade;
        if (NBTHelper.hasTag((ItemStack)stack, (String)"upgrade") && (upgrade = NBTHelper.getShort((ItemStack)stack, (String)"upgrade")) != 1) {
            if (!ComputerCraftRegistry.pocketUpgrades.containsKey(upgrade)) {
                PeripheralsPlusPlus.LOGGER.warn((Object)("A pocket computer upgrade with an ID of " + upgrade + " cannot be found! Removing it..."));
                NBTHelper.removeTag((ItemStack)stack, (String)"upgrade");
                return;
            }
            IPeripheral peripheral = cachedPeripherals.containsKey(computer.getID()) ? cachedPeripherals.get(computer.getID()) : ComputerCraftRegistry.pocketUpgrades.get(upgrade).createPeripheral((Entity)(inventory == null ? null : ((InventoryPlayer)inventory).field_70458_d), stack);
            cachedPeripherals.put(computer.getID(), peripheral);
            computer.setPeripheral(2, peripheral);
            if (ComputerCraftRegistry.pocketUpgrades.get(upgrade) instanceof PocketPeripheralContainer && NBTHelper.hasTag((ItemStack)stack, (String)"upgrades")) {
                if (!cachedExtraPeripherals.containsKey(computer.getID())) {
                    cachedExtraPeripherals.put(computer.getID(), new HashMap());
                }
                NBTTagList list = NBTHelper.getList((ItemStack)stack, (String)"upgrades", (int)5);
                HashMap<Integer, IPeripheral> peripherals = cachedExtraPeripherals.get(computer.getID());
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    int id = (int)list.func_150308_e(i);
                    if (peripherals.containsKey(id)) continue;
                    peripherals.put(id, ComputerCraftRegistry.pocketUpgrades.get(id).createPeripheral((Entity)(inventory == null ? null : ((InventoryPlayer)inventory).field_70458_d), stack));
                }
            }
        }
    }

    public static String getName(String baseName, ItemStack stack) {
        if (NBTHelper.hasTag((ItemStack)stack, (String)"upgrade")) {
            baseName = StatCollector.func_74838_a((String)(baseName + ".upgraded.name"));
            short upgrade = NBTHelper.getShort((ItemStack)stack, (String)"upgrade");
            baseName = upgrade == 1 ? baseName.replace("%s", StatCollector.func_74838_a((String)"upgrade.computercraft:wireless_modem.adjective")) : baseName.replace("%s", StatCollector.func_74838_a((String)ComputerCraftRegistry.pocketUpgrades.get(upgrade).getUnlocalisedAdjective()));
        } else {
            baseName = StatCollector.func_74838_a((String)(baseName + ".name"));
        }
        return baseName;
    }

    public static void update(Entity entity, ItemStack stack, ServerComputer computer) {
        if (NBTHelper.hasTag((ItemStack)stack, (String)"upgrade")) {
            short upgrade = NBTHelper.getShort((ItemStack)stack, (String)"upgrade");
            if (cachedPeripherals.get(computer.getID()) == null) {
                return;
            }
            if (upgrade != 1) {
                ComputerCraftRegistry.pocketUpgrades.get(upgrade).update(entity, stack, cachedPeripherals.get(computer.getID()));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.isCanceled() && (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && event.useItem != Event.Result.DENY && event.entityPlayer.func_71045_bC() != null && event.entityPlayer.func_71045_bC().func_77973_b() instanceof ItemPocketComputer) {
            event.setCanceled(ComputerCraftHooks.rightClick(event.world, event.entityPlayer, event.entityPlayer.func_71045_bC()));
        }
    }

    public static boolean rightClick(World world, EntityPlayer player, ItemStack stack) {
        short upgrade;
        if (NBTHelper.hasTag((ItemStack)stack, (String)"upgrade") && (upgrade = NBTHelper.getShort((ItemStack)stack, (String)"upgrade")) != 1) {
            return ComputerCraftRegistry.pocketUpgrades.get(upgrade).onRightClick(world, player, stack, cachedPeripherals.get(NBTHelper.getInt((ItemStack)stack, (String)"computerID")));
        }
        return false;
    }
}

