/*
 * Decompiled with CFR 0.152.
 */
package mantle.lib;

import java.io.File;
import java.io.IOException;
import mantle.books.external.ZipLoader;
import mantle.lib.CoreRepo;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.io.FilenameUtils;

public class CoreConfig {
    static Configuration config;
    public static File configFolder;
    public static boolean silenceEnvChecks;
    public static boolean debug_enableConsole;
    public static boolean debug_enableChat;
    public static boolean dumpBiomeIDs;
    public static boolean dumpPotionIDs;
    public static boolean dumpEnchantIDs;
    public static boolean identifyLogs;

    public static void loadConfiguration(File mainConfigFolder) {
        CoreRepo.logger.info("Loading configuration from disk.");
        try {
            configFolder = new File(mainConfigFolder.getCanonicalPath(), "SlimeKnights");
            if (!configFolder.exists()) {
                configFolder.mkdirs();
            }
        }
        catch (IOException e) {
            CoreRepo.logger.error("Error getting/creating Mantle configuration directory: " + e.getMessage());
        }
        config = new Configuration(new File(configFolder, "Mantle.cfg"));
        config.load();
        silenceEnvChecks = config.get("Environment", "unsupportedLogging", silenceEnvChecks).getBoolean(silenceEnvChecks);
        debug_enableConsole = config.get("DebugHelpers", "enableConsole", debug_enableConsole).getBoolean(debug_enableConsole);
        debug_enableChat = config.get("DebugHelpers", "enableChat", debug_enableChat).getBoolean(debug_enableChat);
        dumpBiomeIDs = config.get("DebugHelpers", "Dump BIOME ID's in log", dumpBiomeIDs).getBoolean(dumpBiomeIDs);
        dumpPotionIDs = config.get("DebugHelpers", "Dump POTION ID's in log", dumpPotionIDs).getBoolean(dumpPotionIDs);
        dumpEnchantIDs = config.get("DebugHelpers", "Dump ENCHANT ID's in log", dumpEnchantIDs).getBoolean(dumpEnchantIDs);
        identifyLogs = config.get("DebugHelpers", "Force all unidentified logging entries (STDOUT/STDERR) through log4j2", identifyLogs).getBoolean(identifyLogs);
        CoreConfig.checkSysOverrides();
        config.save();
        CoreRepo.logger.info("Configuration load completed.");
    }

    private static void checkSysOverrides() {
        if (System.getenv("MANTLE_DBGCONSOLE") != null) {
            debug_enableConsole = true;
            CoreRepo.logger.info("Mantle Console debugging override enabled via system properties.");
        }
        if (System.getenv("MANTLE_DBGCHAT") != null) {
            debug_enableChat = true;
            CoreRepo.logger.info("Mantle Chat debugging override enabled via system properties.");
        }
    }

    public static void loadBookLocations() {
        for (File f : configFolder.listFiles()) {
            if (!f.isFile() || !FilenameUtils.getExtension((String)f.getAbsolutePath()).equalsIgnoreCase("zip")) continue;
            ZipLoader.loadZip(f);
        }
    }

    static {
        silenceEnvChecks = false;
        debug_enableConsole = false;
        debug_enableChat = false;
        dumpBiomeIDs = false;
        dumpPotionIDs = false;
        dumpEnchantIDs = false;
        identifyLogs = false;
    }
}

